<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchSelect = filter_input(INPUT_POST, "searchSelect");
    $paymentStatus = filter_input(INPUT_POST, "searchSelect");
    $searchInput = filter_input(INPUT_POST, "searchInput");
    $userId = filter_input(INPUT_POST, "userId");
    $org_id = $_SESSION["orgid"];

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchSelect) && empty($searchInput) && empty($userId)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "rota.start_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "rota.end_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchInput)) {
        $conditions[] = "(rota.name LIKE :search_key OR rota.depot LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchInput . '%';
    }
    if (!empty($userId)) {
        $conditions[] = "rota.user_id = :user_id";
        $parameters[':user_id'] = $userId;
    }
    if (!empty($searchSelect)) {
        $conditions[] = "rota.status = :select_status";
        $parameters[':select_status'] = $searchSelect;
    }

    // Prepare the SQL query with the conditions
    $query = "SELECT rota.rota_id, rota.name, rota.description, rota.start_date, rota.end_date, rota.day, rota.status, rota.week, rota.month, rota.target, rota.monthly_target, rota.score, rota.user_id, rota.creator_id, rota.date_modified, rota.depot, rota.depot_id, rota.business_category, rota.business_category_code, users.id,
  (
    SELECT SUM(revenue_target.revenue_target)
    FROM revenue_target
    WHERE revenue_target.rota_id = rota.rota_id AND revenue_target.status = 'Active'
  ) AS totalTargets,
  (
    SELECT COUNT(td.id)
    FROM transaction_details td
    WHERE td.transaction_date BETWEEN rota.start_date AND rota.end_date
      AND td.product_id = rota.rota_code
  ) AS totalTransactions,
  (
    SELECT SUM(td.transaction_amount)
    FROM transaction_details td
    WHERE td.transaction_date BETWEEN rota.start_date AND rota.end_date
      AND td.product_id = rota.rota_code
  ) AS totalSales
FROM rota 
INNER JOIN users ON rota.user_id = users.id
WHERE rota.status!='Deleted' AND rota.org_id = '$org_id'";

    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " ORDER BY rota.name ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails)
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
