<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

 session_start();
 $org_id = $_SESSION["orgid"];

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
   //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchSelect = filter_input(INPUT_POST, "searchSelect"); 
    $searchInput =  filter_input(INPUT_POST, "searchInput");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchSelect) && empty($searchInput)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "rota.start_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "rota.end_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchInput)) {
        $conditions[] = "(users.names LIKE :search_key OR users.phone LIKE :search_key OR users.email LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchInput . '%';
    }

    // Always bind :org_id for all usages in the query
    $parameters[':org_id'] = $org_id;

    // Build WHERE clause
    $where = "rota.status != 'Deleted'";
    if (!empty($conditions)) {
        $where .= " AND " . implode(" AND ", $conditions);
    }

    $query = "
  SELECT 
      COUNT(rota.rota_id) AS totalTasks,
      SUM(revenue_target.revenue_target) AS totalTargets,
      (
        SELECT SUM(td.transaction_amount)
        FROM transaction_details td
        WHERE td.agent_id = users.id
          AND td.transaction_date BETWEEN (
            SELECT MIN(rt.target_start_date)
            FROM revenue_target rt
            WHERE rt.user_id = users.id AND rt.org_id = :org_id
          ) AND NOW()
      ) AS totalSales,
      (
        SELECT COUNT(td.id)
        FROM transaction_details td
        WHERE td.agent_id = users.id
          AND td.transaction_date BETWEEN (
            SELECT MIN(rt.target_start_date)
            FROM revenue_target rt
            WHERE rt.user_id = users.id AND rt.org_id = :org_id
          ) AND NOW()
      ) AS totalTransactions,
      rota.name,
      users.id,
      users.names,
      users.avatar,
      workforce.status AS workforce_status,
      workforce.department_id,
      workforce.role_id
  FROM 
      rota 
  INNER JOIN 
      users 
      ON rota.user_id = users.id 
  INNER JOIN
      workforce 
      ON workforce.user_id = users.id
     AND workforce.org_id = :org_id
  LEFT JOIN revenue_target 
     ON revenue_target.rota_id = rota.rota_id AND revenue_target.user_id = users.id AND revenue_target.status = 'Active' AND revenue_target.org_id = :org_id
  WHERE 
      $where
  GROUP BY 
      users.id
  ORDER BY 
      users.names ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = []; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails)
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
