<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');  // Ensure JSON response type

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];
$usernames = filter_input(INPUT_POST, "usernames");
$staff = filter_input(INPUT_POST, "staff");
$task = filter_input(INPUT_POST, "task");
$taskname = filter_input(INPUT_POST, "taskname");
$month = filter_input(INPUT_POST, "month");
$year = date('Y');  // Current year dynamically
$week = filter_input(INPUT_POST, "week");
$day = filter_input(INPUT_POST, "day");
$rotastartdate = filter_input(INPUT_POST, "rotastartdate");
$rotaenddate = filter_input(INPUT_POST, "rotaenddate");
$starttime = filter_input(INPUT_POST, "starttime");
$endtime = filter_input(INPUT_POST, "endtime");
$target = filter_input(INPUT_POST, "target");
$depot_id = filter_input(INPUT_POST, "revenuePointToRota");
$depot_name = filter_input(INPUT_POST, "revenuePointname");
$depot_code = filter_input(INPUT_POST, "depotCode");
$description = filter_input(INPUT_POST, "description");
$productcode = filter_input(INPUT_POST, "productcode");
$category = filter_input(INPUT_POST, "category");
$categorycode = filter_input(INPUT_POST, "categorycode");
$businessCategoryRota = filter_input(INPUT_POST, "businessCategoryRota");
$businesscategorycode = filter_input(INPUT_POST, "businesscategorycode");

$status = 'Active';

if ($task == 0) {
    // Select all active products
    $productStmt = $conn->prepare("SELECT id, name, product_code, category, category_code FROM tblproduct WHERE status = 'active'");
    $productStmt->execute();
    $products = $productStmt->fetchAll(PDO::FETCH_ASSOC);
    $created = 0;
    $exists = 0;
    foreach ($products as $product) {
        // Check if record already exists for this product
        $checkQuery = "SELECT 1 FROM rota WHERE rota_code = ? AND user_id = ? AND status != 'Deleted'";
        $checkStmt = $conn->prepare($checkQuery);
        $checkStmt->execute([$product['id'], $staff]);
        if ($checkStmt->fetch()) {
            $exists++;
            continue;
        }
        // Insert into rota table for this product
        $insertRotaQuery = "
            INSERT INTO rota (
                name, description, location, rota_code, product_code, product_category, product_category_code,
                start_date, end_date, start_time, end_time, day, status, week, month, year, target, user_names,
                user_id, creator_id, depot, depot_id, depot_code, business_category, business_category_code, org_name, org_id
            ) VALUES (
                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
            )
        ";
        $insertRota = $conn->prepare($insertRotaQuery);
        $rotaInserted = $insertRota->execute([
            $product['name'], $description, $depot_name, $product['id'], $product['product_code'], $product['category'], $product['category_code'],
            $rotastartdate, $rotaenddate, $starttime, $endtime, $day, $status, $week, $month, $year,
            $target, $usernames, $staff, $userloggedid, $depot_name, $depot_id, $depot_code, 
            $businessCategoryRota, $businesscategorycode, $orgname, $orgid
        ]);
        if ($rotaInserted) {
            $rota_id = $conn->lastInsertId();
            // Insert into revenue_target table for this product
            $insertTargetQuery = "
                INSERT INTO revenue_target (
                    rota_id, revenue_target, product_id, product_name, product_code, target_start_date, 
                    target_end_date, user_names, user_id, sessionUserId, org_name, org_id
                ) VALUES (
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                )
            ";
            $insertTarget = $conn->prepare($insertTargetQuery);
            $insertTarget->execute([
                $rota_id, $target, $product['id'], $taskname, $product['product_code'], $rotastartdate, $rotaenddate, 
                $usernames, $staff, $userloggedid, $orgname, $orgid
            ]);
            $created++;
        }
    }
    $json_data = ['status' => 'created', 'created' => $created, 'skipped_exists' => $exists];
    echo json_encode($json_data);
    exit;
}

// Check if record already exists
$checkQuery = "SELECT 1 FROM rota WHERE rota_code = ? AND user_id = ? AND status != 'Deleted'";
$checkStmt = $conn->prepare($checkQuery);
$checkStmt->execute([$task, $staff]);

if ($checkStmt->fetch()) {
    $json_data = ['status' => 'exists'];
    echo json_encode($json_data);
    exit;
}

// Insert into rota table
$insertRotaQuery = "
    INSERT INTO rota (
        name, description, location, rota_code, product_code, product_category, product_category_code,
        start_date, end_date, start_time, end_time, day, status, week, month, year, target, user_names,
        user_id, creator_id, depot, depot_id, depot_code, business_category, business_category_code, org_name, org_id
    ) VALUES (
        ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
    )
";

$insertRota = $conn->prepare($insertRotaQuery);
$rotaInserted = $insertRota->execute([
    $taskname, $description, $depot_name, $task, $productcode, $category, $categorycode,
    $rotastartdate, $rotaenddate, $starttime, $endtime, $day, $status, $week, $month, $year,
    $target, $usernames, $staff, $userloggedid, $depot_name, $depot_id, $depot_code, 
    $businessCategoryRota, $businesscategorycode, $orgname, $orgid
]);

if ($rotaInserted) {
    // Get the last inserted rota_id
    $rota_id = $conn->lastInsertId();

    // Insert into revenue_target table
    $insertTargetQuery = "
        INSERT INTO revenue_target (
            rota_id, revenue_target, product_id, product_name, product_code, target_start_date, 
            target_end_date, user_names, user_id, sessionUserId, org_name, org_id
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
        )
    ";

    $insertTarget = $conn->prepare($insertTargetQuery);
    $targetInserted = $insertTarget->execute([
        $rota_id, $target, $task, $taskname, $productcode, $rotastartdate, $rotaenddate, 
        $usernames, $staff, $userloggedid, $orgname, $orgid
    ]);

    if ($targetInserted) {
        $json_data = ['status' => 'created'];
        echo json_encode($json_data);
    } else {
        $json_data = ['status' => 'not created (target)'];
        echo json_encode($json_data);
    }
} else {
    $json_data = ['status' => 'not created (rota)'];
    echo json_encode($json_data);
}
?>
