<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

// Print the raw POST data for debugging
error_log("Raw POST data: " . print_r($_POST, true));

$startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
$endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);
$bankname = filter_input(INPUT_POST, "searchKey", FILTER_DEFAULT);
$productname = filter_input(INPUT_POST, "productname", FILTER_DEFAULT);
$productid = filter_input(INPUT_POST, "productid", FILTER_DEFAULT);
// Debugging: print received inputs
error_log("Received startDate: " . $startDateInput);
error_log("Received endDate: " . $endDateInput);

// Ensure both dates are provided and are not empty
if (empty($startDateInput) || empty($endDateInput)) {
    echo json_encode(["error" => "Both startDate and endDate are required"]);
    exit;
}

// Validate date format (YYYY-MM-DD)
if (!DateTime::createFromFormat('Y-m-d', $startDateInput) || !DateTime::createFromFormat('Y-m-d', $endDateInput)) {
    echo json_encode(["error" => "Invalid date format. Use YYYY-MM-DD"]);
    exit;
}

$getServiceRequestQuery = "SELECT SUM(transaction_amount) AS totaldailysales 
                           FROM transaction_details 
                           WHERE bank_account_name!='' 
                           AND transaction_status='approved' 
                           AND deposit_status='Approved' 
                           AND transaction_date BETWEEN :startDate AND :endDate AND product_name='$productname' AND product_id='$productid' AND bank_account_name='$bankname'";

$getServiceRequest = $conn->prepare($getServiceRequestQuery);
$getServiceRequest->bindParam(':startDate', $startDateInput);
$getServiceRequest->bindParam(':endDate', $endDateInput);
$getServiceRequest->execute();

$getServiceRequest->setFetchMode(PDO::FETCH_ASSOC);

if ($getServiceRequest->rowCount() == 0) {
    echo 'somethingwrong';
    exit;
} else if ($getServiceRequest->rowCount() == 1) {
    $row = $getServiceRequest->fetch();
    $totaldailysales = $row['totaldailysales'];

    $getDriversQuery = "SELECT id, cfname,cphone,product_name, product_id,transaction_amount,agent_name,depot,receipt_no, bank_account_name, bank_account_number
                        FROM transaction_details 
                        WHERE bank_account_name!='' 
                        AND transaction_status='approved' 
                        AND deposit_status='Approved' 
                        AND transaction_date BETWEEN :startDate AND :endDate AND product_name='$productname' AND product_id='$productid' AND bank_account_name='$bankname'
                        ORDER BY id ASC";

    $getDrivers = $conn->prepare($getDriversQuery);
    $getDrivers->bindParam(':startDate', $startDateInput);
    $getDrivers->bindParam(':endDate', $endDateInput);
    $getDrivers->execute();
    $getDrivers->setFetchMode(PDO::FETCH_ASSOC);

    if ($getDrivers->rowCount() == 0) {
        $json_data = array("details" => 'No Data');
        echo json_encode($json_data);
        exit;
    } else if ($getDrivers->rowCount() > 0) {
        $totalrecords = $getDrivers->rowCount();
        $details = [];

        while ($rowDs = $getDrivers->fetch()) {
            $details[] = array(
                'id' => $rowDs['id'],
                'cfname' => $rowDs['cfname'],
                'cphone' => $rowDs['cphone'],
				'product_name' => $rowDs['product_name'], 
				'product_id' => $rowDs['product_id'],
                'transaction_amount' => $rowDs['transaction_amount'], 
                'agent_name' => $rowDs['agent_name'],
                'depot' => $rowDs['depot'],
                'receipt_no' => $rowDs['receipt_no'],
                'bank_account_name' => $rowDs['bank_account_name']
            );
        }

        $json_data = array(
            "details" => $details,
            'numofrows' => $totalrecords,
            'total' => $totaldailysales
        );

        echo json_encode($json_data);
        exit;
    }
}
?>