<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../../xd-assets/backend/config/dbconfig.php';
 
$userloggedid = $_SESSION["userid"];

// Execute the query with LIMIT 300
$getproductsquery = "SELECT 
                        COUNT(depot) as depotsNumber,
                        code_id, 
                        code, 
                        address, 
                        product_name, 
                        product_id, 
						product_charge,
                        tenant_name, 
                        tenant_phone, 
                        tenant_email, 
                        category, 
                        type, 
                        depot, 
                        depot_id,
                        zone, 
                        status 
                     FROM 
                        shop_rental 
                     WHERE 
                        type='Shop number' 
                        AND status!='Deleted' 
                     GROUP BY depot,depot_id ORDER BY 
                        depot ASC";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->execute();

// Separate query to get the total number of rows
$getTotalRowsQuery = "SELECT COUNT(depot) as total_rows 
                      FROM 
                        shop_rental 
                      WHERE 
                        type='Shop number' 
                        AND status!='Deleted' GROUP BY depot";

$getTotalRows = $conn->prepare($getTotalRowsQuery);
$getTotalRows->execute();
$totalRecords = $getTotalRows->fetchColumn();

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        'details' => array(),
        'numofrows' => 0,
        'total_rows' => $totalRecords
    );
    echo json_encode($json_data);
    exit;
} else {
    $nestedData = array();
    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }
    $json_data = array(
        "details" => $nestedData,
        'numofrows' => $getproducts->rowCount(),
        'total_rows' => $totalRecords
    );
    echo json_encode($json_data);
    exit;
}
?>
