<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../../xd-assets/backend/config/dbconfig.php';

try {
    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $paymentStatus = filter_input(INPUT_POST, "paymentStatus");
    $category = filter_input(INPUT_POST, "category");
    $categoryid = filter_input(INPUT_POST, "categoryid");
    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($paymentStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($paymentStatus)) {
        if ($paymentStatus === 'All') {
            // Handle case for 'All' (i.e., no filtering by status)
        } else {
            $conditions[] = "status = :paymentStatus";
            $parameters[':paymentStatus'] = $paymentStatus;
        }
    }

    if (!empty($startDateInput)) {
       // $conditions[] = "tenancy_start_date >= :start_date";
      //  $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
     //   $conditions[] = "tenancy_start_date <= :end_date";
      //  $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
       // $conditions[] = "(code LIKE :search_key OR tenant_name LIKE :search_key OR tenant_phone LIKE :search_key)";
       // $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the conditions
    $query = "SELECT 
                        code_id, 
                        code, 
                        address, 
                        product_name, 
                        product_id, 
                        product_charge,
                        tenant_name, 
                        tenant_phone, 
                        tenant_email, 
                        category, 
                        category_id,
                        type, 
                        depot, 
                        zone, 
                        status 
                     FROM 
                        market_stands
                     WHERE 
                        type='Marketstand number' 
                        AND status!='Deleted' AND category='$category' AND category_id='$categoryid'";
 
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " ORDER BY code ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
