<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
 
require_once '../../../../../xd-assets/backend/config/dbconfig.php';
$userloggedid=$_SESSION["userid"];
// Retrieve the POST inputs
$productName = filter_input(INPUT_POST, "productName");
$productId = filter_input(INPUT_POST, "productId");
$product_price = filter_input(INPUT_POST, "product_price");
$product_code = filter_input(INPUT_POST, "product_code");
$productcategory = filter_input(INPUT_POST, "productcategory");
$productcategorycode = filter_input(INPUT_POST, "productcategorycode");
$description = filter_input(INPUT_POST, "description");
$locationName = filter_input(INPUT_POST, "locationName");
$locationId = filter_input(INPUT_POST, "locationId");
$depotcode = filter_input(INPUT_POST, "depotcode");
$address = filter_input(INPUT_POST, "address"); 
$department = filter_input(INPUT_POST, "department");
$productCode = filter_input(INPUT_POST, "productCode"); 
$codeType = filter_input(INPUT_POST, "codeType");
$lat = filter_input(INPUT_POST, "lat");
$lng = filter_input(INPUT_POST, "lng");
$category_id = filter_input(INPUT_POST, "categoryId");
$category = filter_input(INPUT_POST, "category");
$zone = filter_input(INPUT_POST, "zone");
$status = 'For Rent';

// Check if the code already exists
$checkQuery = "SELECT COUNT(*) FROM market_stands WHERE code = :code";
$checkStmt = $conn->prepare($checkQuery);
$checkStmt->bindParam(':code', $productCode);
$checkStmt->execute();
$codeExists = $checkStmt->fetchColumn();

if ($codeExists > 0) {
    // Code already exists, return an error response
    $json_data = array(
        'status' => 'Marketstand number already exists'
    );
    echo json_encode($json_data);
    exit;
} else {
    // Code does not exist, proceed with the insert
    $insertnewuserQuery = "INSERT INTO market_stands (code, description, address, product_name, product_id, product_charge,product_code, productcategory, productcategorycode, category, category_id, type, depot, depot_id, depot_code, zone, department, lat, lng,status,sessionUserId) 
    VALUES (:productCode, :description, :address, :productName, :productId, :productcharge,:product_code, :productcategory, :productcategorycode, :category, :categoryid, :codeType, :locationName, :locationId, :depotcode, :zone, :department, :lat, :lng, :status,:userloggedid)";
    
    $insertnewUser = $conn->prepare($insertnewuserQuery);
    
    // Bind parameters
    $insertnewUser->bindParam(':productCode', $productCode); 
    $insertnewUser->bindParam(':description', $description);
    $insertnewUser->bindParam(':productName', $productName);
    $insertnewUser->bindParam(':productId', $productId);
    $insertnewUser->bindParam(':productcharge', $product_price);
    $insertnewUser->bindParam(':product_code', $product_code);
    $insertnewUser->bindParam(':productcategory', $productcategory);
    $insertnewUser->bindParam(':productcategorycode', $productcategorycode);
    $insertnewUser->bindParam(':codeType', $codeType);
    $insertnewUser->bindParam(':locationName', $locationName);
    $insertnewUser->bindParam(':locationId', $locationId);
    $insertnewUser->bindParam(':depotcode', $depotcode); 
    $insertnewUser->bindParam(':department', $department);
    $insertnewUser->bindParam(':lat', $lat);
    $insertnewUser->bindParam(':lng', $lng);
    $insertnewUser->bindParam(':status', $status);
    $insertnewUser->bindParam(':address', $address);
    $insertnewUser->bindParam(':category', $category);
    $insertnewUser->bindParam(':categoryid', $category_id);
    $insertnewUser->bindParam(':zone', $zone);
    $insertnewUser->bindParam(':userloggedid', $userloggedid);
    // Execute the insert query
    if ($insertnewUser->execute()) {
        $json_data = array(
            'status' => 'Created'
        );
    } else {
        $json_data = array(
            'status' => 'not created, something went wrong'
        );
    }

    echo json_encode($json_data);
    exit;
}
?>
