<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
 
require_once '../../../../../xd-assets/backend/config/dbconfig.php';
$userloggedid = $_SESSION["userid"];

// Retrieve the POST inputs
$productName = filter_input(INPUT_POST, "productName");
$productId = filter_input(INPUT_POST, "productId");
$product_price = filter_input(INPUT_POST, "product_price");
$product_code = filter_input(INPUT_POST, "product_code");
$productcategory = filter_input(INPUT_POST, "productcategory");
$productcategorycode = filter_input(INPUT_POST, "productcategorycode");
$description = filter_input(INPUT_POST, "description");
$locationName = filter_input(INPUT_POST, "locationName");
$locationId = filter_input(INPUT_POST, "locationId");
$depotcode = filter_input(INPUT_POST, "depotcode");
$address = filter_input(INPUT_POST, "address");
$department = filter_input(INPUT_POST, "department");
$productCode = filter_input(INPUT_POST, "productCode");
$codeType = filter_input(INPUT_POST, "codeType");
$lat = filter_input(INPUT_POST, "lat");
$lng = filter_input(INPUT_POST, "lng");
$category_id = filter_input(INPUT_POST, "categoryId");
$category = filter_input(INPUT_POST, "category");
$zone = filter_input(INPUT_POST, "zone");
$status = filter_input(INPUT_POST, "status");
$codeid = filter_input(INPUT_POST, "codeid");

$tenant_names = filter_input(INPUT_POST, "tenant_names");
$tenant_phone = filter_input(INPUT_POST, "tenant_phone");
$tenant_email = filter_input(INPUT_POST, "tenant_email");
$tenant_nrc = filter_input(INPUT_POST, "tenant_nrc");

    // Code exists, proceed with the update
    $updateQuery = "UPDATE booths 
                    SET code = :productCode,
                        description = :description, 
                        address = :address, 
                        product_name = :productName, 
                        product_id = :productId, 
                        product_charge = :productcharge, 
                        product_code = :product_code, 
                        productcategory = :productcategory, 
                        productcategorycode = :productcategorycode,
                        tenant_name = :tenant_names, 
                        tenant_phone = :tenant_phone,
                        tenant_nrc = :tenant_nrc,
                        tenant_email = :tenant_email,
                        category = :category, 
                        category_id = :categoryid, 
                        type = :codeType, 
                        depot = :locationName, 
                        depot_id = :locationId, 
                        depot_code = :depotcode, 
                        zone = :zone, 
                        department = :department, 
                        lat = :lat, 
                        lng = :lng, 
                        status = :status, 
                        sessionUserId = :userloggedid 
                    WHERE code_id = :codeid";
    
    $updateStmt = $conn->prepare($updateQuery);
    
    // Bind parameters
    $updateStmt->bindParam(':productCode', $productCode); 
    $updateStmt->bindParam(':description', $description);
    $updateStmt->bindParam(':productName', $productName);
    $updateStmt->bindParam(':productId', $productId);
    $updateStmt->bindParam(':productcharge', $product_price);
    $updateStmt->bindParam(':product_code', $product_code);
    $updateStmt->bindParam(':productcategory', $productcategory);
    $updateStmt->bindParam(':productcategorycode', $productcategorycode);
    $updateStmt->bindParam(':codeType', $codeType);
    $updateStmt->bindParam(':locationName', $locationName);
    $updateStmt->bindParam(':locationId', $locationId);
    $updateStmt->bindParam(':depotcode', $depotcode); 
    $updateStmt->bindParam(':department', $department);
    $updateStmt->bindParam(':lat', $lat);
    $updateStmt->bindParam(':lng', $lng);
    $updateStmt->bindParam(':status', $status);
    $updateStmt->bindParam(':address', $address);
    $updateStmt->bindParam(':category', $category);
    $updateStmt->bindParam(':categoryid', $category_id);
    $updateStmt->bindParam(':zone', $zone);
    $updateStmt->bindParam(':userloggedid', $userloggedid);
    $updateStmt->bindParam(':codeid', $codeid);

    $updateStmt->bindParam(':tenant_names', $tenant_names);
    $updateStmt->bindParam(':tenant_phone', $tenant_phone);
    $updateStmt->bindParam(':tenant_email', $tenant_email);
    $updateStmt->bindParam(':tenant_nrc', $tenant_nrc);
    // Execute the update query
    if ($updateStmt->execute()) {
        $json_data = array(
            'status' => 'Updated'
        );
    } else {
        $json_data = array(
            'status' => 'Update failed, something went wrong'
        );
    }
 

echo json_encode($json_data);
exit;
?>
