<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../../xd-assets/backend/config/dbconfig.php';

$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$userloggedid = $_SESSION["userid"];

// Execute the query with LIMIT 300
$getproductsquery = "SELECT 
                        code_id, 
                        code, 
                        address, 
                        product_name, 
                        product_id, 
						product_charge,
                        tenant_name, 
                        tenant_phone, 
                        tenant_email, 
                        tenant_nrc,
                        category, 
                        type, 
                        depot, 
                        zone, 
                        status 
                     FROM 
                        booths 
                     WHERE 
                        type='Booth number' 
                        AND status!='Deleted' 
                     ORDER BY 
                        code_id DESC 
                     LIMIT 300";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->execute();

// Separate query to get the total number of rows
$getTotalRowsQuery = "SELECT COUNT(*) as total_rows 
                      FROM 
                        booths 
                      WHERE 
                        type='Booth number' 
                        AND status!='Deleted'";

$getTotalRows = $conn->prepare($getTotalRowsQuery);
$getTotalRows->execute();
$totalRecords = $getTotalRows->fetchColumn();

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        'details' => array(),
        'numofrows' => 0,
        'total_rows' => $totalRecords
    );
    echo json_encode($json_data);
    exit;
} else {
    $nestedData = array();
    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }
    $json_data = array(
        "details" => $nestedData,
        'numofrows' => $getproducts->rowCount(),
        'total_rows' => $totalRecords
    );
    echo json_encode($json_data);
    exit;
}
?>
