<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
session_start();

require_once '../../../../../xd-assets/backend/config/dbconfig.php';
$userloggedid = $_SESSION["userid"];

// Retrieve the POST inputs
$productName = filter_input(INPUT_POST, "productName");
$productId = filter_input(INPUT_POST, "productId");
$product_price = filter_input(INPUT_POST, "product_price");
$product_code = filter_input(INPUT_POST, "product_code");
$productcategory = filter_input(INPUT_POST, "productcategory");
$productcategorycode = filter_input(INPUT_POST, "productcategorycode");
$description = filter_input(INPUT_POST, "description");
$locationName = filter_input(INPUT_POST, "locationName");
$locationId = filter_input(INPUT_POST, "locationId");
$depotcode = filter_input(INPUT_POST, "depotcode");
$address = filter_input(INPUT_POST, "address");
$department = filter_input(INPUT_POST, "department");
$codeType = filter_input(INPUT_POST, "codeType");
$lat = filter_input(INPUT_POST, "lat");
$lng = filter_input(INPUT_POST, "lng");
$category_id = filter_input(INPUT_POST, "categoryId");
$category = filter_input(INPUT_POST, "category");
$zone = filter_input(INPUT_POST, "zone");
$status = 'For Rent';

// Retrieve the last code from the booths table
$getLastCodeQuery = "SELECT code FROM booths ORDER BY code DESC LIMIT 1";
$getLastCodeStmt = $conn->prepare($getLastCodeQuery);
$getLastCodeStmt->execute();
$lastCode = $getLastCodeStmt->fetchColumn();

// Increment the code by 1 (handle the case where no code exists yet)
$newCode = $lastCode ? $lastCode + 1 : 1;

// Check if the new code already exists (edge case)
$checkQuery = "SELECT COUNT(*) FROM booths WHERE code = :code";
$checkStmt = $conn->prepare($checkQuery);
$checkStmt->bindParam(':code', $newCode);
$checkStmt->execute();
$codeExists = $checkStmt->fetchColumn();

if ($codeExists > 0) {
    // Code already exists, return an error response
    $json_data = array(
        'status' => 'Booth number already exists'
    );
    echo json_encode($json_data);
    exit;
} else {
    // Proceed with the insert using the incremented code
    $insertQuery = "INSERT INTO booths (code, description, address, product_name, product_id, product_charge, 
                    product_code, productcategory, productcategorycode, category, category_id, type, depot, 
                    depot_id, depot_code, zone, department, lat, lng, status, sessionUserId) 
                    VALUES (:code, :description, :address, :productName, :productId, :productcharge, :product_code, 
                    :productcategory, :productcategorycode, :category, :categoryid, :codeType, :locationName, 
                    :locationId, :depotcode, :zone, :department, :lat, :lng, :status, :userloggedid)";

    $insertStmt = $conn->prepare($insertQuery);

    // Bind parameters
    $insertStmt->bindParam(':code', $newCode); 
    $insertStmt->bindParam(':description', $description);
    $insertStmt->bindParam(':productName', $productName);
    $insertStmt->bindParam(':productId', $productId);
    $insertStmt->bindParam(':productcharge', $product_price);
    $insertStmt->bindParam(':product_code', $product_code);
    $insertStmt->bindParam(':productcategory', $productcategory);
    $insertStmt->bindParam(':productcategorycode', $productcategorycode);
    $insertStmt->bindParam(':codeType', $codeType);
    $insertStmt->bindParam(':locationName', $locationName);
    $insertStmt->bindParam(':locationId', $locationId);
    $insertStmt->bindParam(':depotcode', $depotcode);
    $insertStmt->bindParam(':department', $department);
    $insertStmt->bindParam(':lat', $lat);
    $insertStmt->bindParam(':lng', $lng);
    $insertStmt->bindParam(':status', $status);
    $insertStmt->bindParam(':address', $address);
    $insertStmt->bindParam(':category', $category);
    $insertStmt->bindParam(':categoryid', $category_id);
    $insertStmt->bindParam(':zone', $zone);
    $insertStmt->bindParam(':userloggedid', $userloggedid);

    // Execute the insert query
    if ($insertStmt->execute()) {
        $json_data = array(
            'status' => 'Created',
            'newCode' => $newCode
        );
    } else {
        $json_data = array(
            'status' => 'Not created, something went wrong'
        );
    }

    echo json_encode($json_data);
    exit;
}
?>
