<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

// Retrieve logged-in user's ID
$userloggedid = $_SESSION["userid"]; 
$id = filter_input(INPUT_POST, "id");
$categoryname = filter_input(INPUT_POST, "categoryname");
$categoryCode = filter_input(INPUT_POST, "categoryCode"); 
$description = filter_input(INPUT_POST, "description"); 
$type = filter_input(INPUT_POST, "accountType"); 
$status = filter_input(INPUT_POST, "status");

try {
    // Prepare the SQL UPDATE query
    $insertnewuserQuery = "UPDATE general_ledger 
                           SET code = :categoryCode,
                               name = :categoryname,
                              description = :description,  
                               type = :type, 
                               status = :status,
                               sessionUserId = :userloggedid 
                           WHERE pc_id = :id";  // Removed the 'name' condition

    // Prepare and bind parameters
    $insertnewUser = $conn->prepare($insertnewuserQuery);
    $insertnewUser->bindParam(':categoryname', $categoryname);
    $insertnewUser->bindParam(':categoryCode', $categoryCode); 
    $insertnewUser->bindParam(':description', $description); 
    $insertnewUser->bindParam(':type', $type); 
    $insertnewUser->bindParam(':status', $status);
    $insertnewUser->bindParam(':userloggedid', $userloggedid);
    $insertnewUser->bindParam(':id', $id);

    // Execute the query
    $insertnewUser->execute();

    // Check if any rows were updated
    if ($insertnewUser->rowCount() > 0) {
        $json_data = array(
            'status' => 'Updated'
        );
    } else {
        $json_data = array(
            'status' => 'not updated, please try again!'
        );
    }

    // Return JSON response
    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    // Return error message in case of a database error
    $json_data = array(
        'status' => 'Database error: ' . $e->getMessage()
    );
    echo json_encode($json_data);
    exit;
}
?>
