<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

// Retrieve logged-in user's ID
$userloggedid = $_SESSION["userid"];

// Retrieve and validate input parameters
$coaid = filter_input(INPUT_POST, "coaid");
$chargerate = filter_input(INPUT_POST, "chargerate");
$levyName = filter_input(INPUT_POST, "levyName");
$levycharge = filter_input(INPUT_POST, "levycharge");
$penalty = filter_input(INPUT_POST, "penalty");
$productCode = filter_input(INPUT_POST, "productCode");
$description = filter_input(INPUT_POST, "description");
$department = filter_input(INPUT_POST, "department");
$category = filter_input(INPUT_POST, "category");
$categorycode = filter_input(INPUT_POST, "categorycode");
$type = filter_input(INPUT_POST, "type");
$units = filter_input(INPUT_POST, "units");
$subcategory = filter_input(INPUT_POST, "subcategory");
$status = filter_input(INPUT_POST, "status");

try {
    // Prepare the SQL UPDATE query
    $insertnewuserQuery = "UPDATE tblproduct 
                           SET name = :levyName,
                               product_code = :productCode,
                               price = :levycharge,
                               charge_rate = :chargerate,
                               description = :description,
                               category = :category,
                               category_code = :categorycode,
                               sub_category = :subcategory,
                               coa_type = :type,
                               department = :department,
                               status = :status,
                               sessionUserId = :userloggedid 
                           WHERE id = :coaid";  // Removed the 'name' condition

    // Prepare and bind parameters
    $insertnewUser = $conn->prepare($insertnewuserQuery);
    $insertnewUser->bindParam(':levyName', $levyName);
    $insertnewUser->bindParam(':productCode', $productCode);
    $insertnewUser->bindParam(':levycharge', $levycharge);
    $insertnewUser->bindParam(':chargerate', $chargerate);
    $insertnewUser->bindParam(':description', $description);
    $insertnewUser->bindParam(':category', $category);
    $insertnewUser->bindParam(':categorycode', $categorycode);
    $insertnewUser->bindParam(':subcategory', $subcategory);
    $insertnewUser->bindParam(':type', $type);
    $insertnewUser->bindParam(':department', $department);
    $insertnewUser->bindParam(':status', $status);
    $insertnewUser->bindParam(':userloggedid', $userloggedid);
    $insertnewUser->bindParam(':coaid', $coaid);

    // Execute the query
    $insertnewUser->execute();

    // Check if any rows were updated
    if ($insertnewUser->rowCount() > 0) {
        $json_data = array(
            'status' => 'Updated'
        );
    } else {
        $json_data = array(
            'status' => 'not updated, please try again!'
        );
    }

    // Return JSON response
    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    // Return error message in case of a database error
    $json_data = array(
        'status' => 'Database error: ' . $e->getMessage()
    );
    echo json_encode($json_data);
    exit;
}
?>
