<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
   // $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
   // $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $coaByStatus = filter_input(INPUT_POST, "coaByStatus");
    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($coaByStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "date_modified >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "date_modified <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($coaByStatus)) {
        if ($coaByStatus === 'All') {
            $conditions[] = "(status = 'active'  OR status = 'Active' OR status = 'pending' OR status = 'Pending' OR status = 'Suspended')";
        } elseif ($coaByStatus === 'Active') {
            $conditions[] = "status = 'Active'";
        } elseif ($coaByStatus === 'Pending') {
            $conditions[] = "(status = 'Pending' OR status = 'pending')";
        } elseif ($coaByStatus === 'Suspended') {
            $conditions[] = "status = 'Suspended'";
        }
    }

    if (!empty($searchKey)) {
        $conditions[] = "(name LIKE :search_key OR code LIKE :search_key OR type LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }
    // Prepare the SQL query with the conditions
    
 //  $query = "SELECT id,name,product_code,image,price,charge_rate,quantity,reorder_level,description,category,category_code,units,product_brand,lead_time,product_location,supplier_name,status FROM tblproduct";
   $query = "SELECT pc_id,code,name,description,type,status FROM general_ledger WHERE status != 'Deleted'";
 
   if (!empty($conditions)) {
    // Use WHERE instead of AND to start the conditions
   // $query .= " WHERE " . implode(" AND ", $conditions);
    $query .= " AND " . implode(" AND ", $conditions);
}

    $query .= "ORDER BY name ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
   // $totalProductTotal = 0; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
     //   $totalProductTotal += $rowDs['balance']; 
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
       // "totalProductTotal" => $totalProductTotal
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
