<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

// Retrieve logged-in user's ID
$userloggedid = $_SESSION["userid"];

// Retrieve and validate input parameters
$depotId = filter_input(INPUT_POST, "depotId");
$depotName = filter_input(INPUT_POST, "depotName");
$depotCode = filter_input(INPUT_POST, "depotCode"); 
$description = filter_input(INPUT_POST, "description");
$address = filter_input(INPUT_POST, "depotaddress");
$email = filter_input(INPUT_POST, "email");
$category = filter_input(INPUT_POST, "category");
$pobox = filter_input(INPUT_POST, "pobox"); 
$contact = filter_input(INPUT_POST, "contact");
$lat = filter_input(INPUT_POST, "lat"); 
$lng = filter_input(INPUT_POST, "lng");
$depotType = filter_input(INPUT_POST, "depotType");
$status = filter_input(INPUT_POST, "depotstatus");

try {
    // Prepare the SQL UPDATE query (corrected syntax)
    $updateQuery = "
        UPDATE depots 
        SET depot_name = :depotName, 
            depot_code = :depotCode, 
            depot_description = :description, 
            depot_type = :depotType, 
            depot_address = :address, 
            depot_po_box = :pobox, 
            depot_email = :email, 
            depot_cotacts = :contact, 
            lat = :lat, 
            lng = :lng, 
            status = :status, 
            depot_category = :category, 
            sessionUserId = :userloggedid 
        WHERE depot_id = :depotId
    ";

    // Prepare and bind parameters
    $updateDepot = $conn->prepare($updateQuery);
    $updateDepot->bindParam(':depotId', $depotId);
    $updateDepot->bindParam(':depotName', $depotName);
    $updateDepot->bindParam(':depotCode', $depotCode);
    $updateDepot->bindParam(':description', $description);
    $updateDepot->bindParam(':depotType', $depotType);
    $updateDepot->bindParam(':address', $address);
    $updateDepot->bindParam(':pobox', $pobox);
    $updateDepot->bindParam(':email', $email);
    $updateDepot->bindParam(':contact', $contact);
    $updateDepot->bindParam(':lat', $lat);
    $updateDepot->bindParam(':lng', $lng);
    $updateDepot->bindParam(':status', $status);
    $updateDepot->bindParam(':category', $category);
    $updateDepot->bindParam(':userloggedid', $userloggedid);

    // Execute the query
    $updateDepot->execute();

    // Check if any rows were updated
    if ($updateDepot->rowCount() > 0) {
        $json_data = array(
            'status' => 'Updated'
        );
    } else {
        $json_data = array(
            'status' => 'not updated, please try again!'
        );
    }

    // Return JSON response
    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    // Return error message in case of a database error
    $json_data = array(
        'status' => 'Database error: ' . $e->getMessage()
    );
    echo json_encode($json_data);
    exit;
}
?>
