<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

// Retrieve logged-in user's ID
$userloggedid = $_SESSION["userid"];
$org_id = $_SESSION["orgid"]; 
// Retrieve and validate input parameters
$coaid = filter_input(INPUT_POST, "coaid");
$chargerate = filter_input(INPUT_POST, "chargerate");
$levyName = filter_input(INPUT_POST, "levyName");
$levycharge = filter_input(INPUT_POST, "levycharge");
$penalty = filter_input(INPUT_POST, "penalty");
$productCode = filter_input(INPUT_POST, "productCode");
$description = filter_input(INPUT_POST, "description");
$department = filter_input(INPUT_POST, "department");
$category = filter_input(INPUT_POST, "category");
$categorycode = filter_input(INPUT_POST, "categorycode");
$type = filter_input(INPUT_POST, "type");
$units = filter_input(INPUT_POST, "units");
$subcategory = filter_input(INPUT_POST, "subcategory");
$status = filter_input(INPUT_POST, "status");

try {
    // Prepare the SQL INSERT query
    $insertQuery = "INSERT INTO tblproduct (
                        name, product_code, price, charge_rate, description, 
                        category, category_code, sub_category, coa_type, 
                        department, status, sessionUserId,org_id
                    ) VALUES (
                        :levyName, :productCode, :levycharge, :chargerate, :description, 
                        :category, :categorycode, :subcategory, :type, 
                        :department, :status, :userloggedid, :org_id
                    )";

    $stmt = $conn->prepare($insertQuery);

    // Bind parameters
    $stmt->bindParam(':levyName', $levyName);
    $stmt->bindParam(':productCode', $productCode);
    $stmt->bindParam(':levycharge', $levycharge);
    $stmt->bindParam(':chargerate', $chargerate);
    $stmt->bindParam(':description', $description);
    $stmt->bindParam(':category', $category);
    $stmt->bindParam(':categorycode', $categorycode);
    $stmt->bindParam(':subcategory', $subcategory);
    $stmt->bindParam(':type', $type);
    $stmt->bindParam(':department', $department);
    $stmt->bindParam(':status', $status);
    $stmt->bindParam(':userloggedid', $userloggedid);
    $stmt->bindParam(':org_id', $org_id);

    // Execute
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $json_data = array('status' => 'Updated');
    } else {
        $json_data = array('status' => 'Insert failed');
    }

    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    $json_data = array('status' => 'Database error: ' . $e->getMessage());
    echo json_encode($json_data);
    exit;
}
?>
