<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchInput = filter_input(INPUT_POST, "searchInput");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchInput)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = ["b.budget_status = 'active'"];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "b.budget_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "b.budget_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchInput)) {
        $conditions[] = "b.budget_item LIKE :search_key";
        $parameters[':search_key'] = '%' . $searchInput . '%';
    }

    // Adjusted subquery for transaction details with date filters
    $transactionSubquery = "
        SELECT 
            product_id, 
            SUM(CAST(transaction_amount AS DECIMAL(18, 8))) AS total_transaction_amount 
        FROM transaction_details
    ";
    if (!empty($startDateInput)) {
        $transactionSubquery .= " WHERE transaction_date >= :start_date_td";
        $parameters[':start_date_td'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $transactionSubquery .= (strpos($transactionSubquery, 'WHERE') !== false ? " AND " : " WHERE ") . "transaction_date <= :end_date_td";
        $parameters[':end_date_td'] = date('Y-m-d', strtotime($endDateInput));
    }
    $transactionSubquery .= " GROUP BY product_id";

    // Prepare the SQL query with the conditions
    $query = "SELECT 
        b.budget_id,
        b.budget_item,
        b.item_id, 
        b.item_code, 
        MAX(b.budget_date) AS budget_date, 
        SUM(CAST(b.budget AS DECIMAL(18, 8))) AS budget, 
        COALESCE(td.total_transaction_amount, 0) AS actualBudget, 
        MAX(b.budget_status) AS budget_status 
    FROM budget b 
    LEFT JOIN ($transactionSubquery) td ON b.item_id = td.product_id 
    WHERE " . implode(" AND ", $conditions) . " 
    GROUP BY b.item_id 
    ORDER BY b.budget_item ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = []; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails)
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
