<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
   // $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
   // $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $input = json_decode(file_get_contents('php://input'), true);
    $product = $input['product'];
    $monthBudgets = $input['monthBudgets'];

    $budgetAccount = filter_var($product['name'], FILTER_SANITIZE_STRING);
    $budgetCategory = 'Some Category'; // Adjust as needed
    $budgetingRate = $product['charge_rate'];
    $maxBudgetAlert = 1000; // Placeholder
    $minBudgetAlert = 100; // Placeholder
    $description = 'Description'; // Placeholder
    $productid = $product['id'];
    $productcode = $product['product_code'];
    $productcategorycode = 123; // Placeholder

    $debug_data = [
        'budgetAccount' => $budgetAccount,
        'budgetCategory' => $budgetCategory,
        'budgetingRate' => $budgetingRate,
        'maxBudgetAlert' => $maxBudgetAlert,
        'minBudgetAlert' => $minBudgetAlert,
        'description' => $description,
        'productid' => $productid,
        'productcode' => $productcode,
        'productcategorycode' => $productcategorycode,
        'monthBudgets' => $monthBudgets
    ];

    file_put_contents('debug_log.txt', print_r($debug_data, true), FILE_APPEND);

    // Insert into budget table
    $insertnewuserQuery = "INSERT INTO budget (
        budget_item, item_id, item_code, item_category_code, budget_code, budget_date, month, week, day, budget, max_alert, min_alert, 
        budget_type, description, user_id, department, budget_category, budget_status, 
        timestamp, sessionUserId, org_name, org_id
    ) VALUES (
        :budget_item, :item_id, :item_code, :item_category_code, :budget_code, :budget_date, :month, :week, :day, :budget_amount, :max_alert, :min_alert, 
        :budget_type, :description, :user_id, :department, :budget_category, :budget_status, 
        :timestamp, :sessionUserId, :org_name, :org_id
    )";

    $user_id = $_SESSION["userid"];
    $department = 'active'; // Default value as per table definition
    $budget_status = 'active'; // Assuming the default status 
    $timestamp = date('Y-m-d H:i:s'); // Current timestamp
    $sessionUserId = $user_id; // Assuming the session user ID is the same as user ID
    $org_name = 'My Organization'; // Placeholder for organization name
    $org_id = 1; // Placeholder

    $insertnewUser = $conn->prepare($insertnewuserQuery);

    foreach ($monthBudgets as $budget) {
        $budget_code = uniqid(); // Generating a unique code for the budget

        $budget_date = new DateTime($budget['date']);
        $month = $budget_date->format('F'); // Full month name, e.g. January
        $week = $budget_date->format('W'); // Week number of the year
        $day = $budget_date->format('l'); // Full day name, e.g. Monday

        $insertnewUser->bindParam(':budget_item', $budgetAccount);
        $insertnewUser->bindParam(':item_id', $productid);
        $insertnewUser->bindParam(':item_code', $productcode);
        $insertnewUser->bindParam(':item_category_code', $productcategorycode);
        $insertnewUser->bindParam(':budget_code', $budget_code);
        $insertnewUser->bindParam(':budget_date', $budget['date']);
        $insertnewUser->bindParam(':month', $month);
        $insertnewUser->bindParam(':week', $week);
        $insertnewUser->bindParam(':day', $day);
        $insertnewUser->bindParam(':budget_amount', $budget['budget']); 
        $insertnewUser->bindParam(':max_alert', $maxBudgetAlert);
        $insertnewUser->bindParam(':min_alert', $minBudgetAlert);
        $insertnewUser->bindParam(':budget_type', $budgetingRate);
        $insertnewUser->bindParam(':description', $description); 
        $insertnewUser->bindParam(':user_id', $user_id);
        $insertnewUser->bindParam(':department', $department);
        $insertnewUser->bindParam(':budget_category', $budgetCategory);
        $insertnewUser->bindParam(':budget_status', $budget_status); 
        $insertnewUser->bindParam(':timestamp', $timestamp);
        $insertnewUser->bindParam(':sessionUserId', $sessionUserId);
        $insertnewUser->bindParam(':org_name', $org_name);
        $insertnewUser->bindParam(':org_id', $org_id);

        if (!$insertnewUser->execute()) {
            throw new Exception("Error inserting budget data.");
        }
    }

    $json_data = array('status' => 'created');
    echo json_encode($json_data);
} catch (PDOException $e) {
    $json_data = array('status' => 'error', 'message' => $e->getMessage());
    echo json_encode($json_data);
} catch (Exception $e) {
    $json_data = array('status' => 'error', 'message' => $e->getMessage());
    echo json_encode($json_data);
}
?>
