<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
  //  $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    // set the PDO error mode to exception
   // $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Adjust the SQL query to ensure 'actualBudget' is calculated per each 'budget' row
  $getproductsquery = "SELECT 
    b.budget_id,
    b.budget_item,
    b.item_id, 
    b.item_code, 
    MAX(b.budget_date) AS budget_date, 
    SUM(CAST(b.budget AS DECIMAL(18, 8))) AS budget, 
    COALESCE(td.total_transaction_amount, 0) AS actualBudget, 
    MAX(b.budget_status) AS budget_status 
    FROM budget b 
    LEFT JOIN ( SELECT product_id, SUM(CAST(transaction_amount AS DECIMAL(18, 8))) AS total_transaction_amount 
    FROM transaction_details 
    GROUP BY product_id ) td 
    ON b.item_id = td.product_id 
    WHERE b.budget_status = 'active' 
    GROUP BY b.item_id 
    ORDER BY b.budget_item ASC;";
        
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $totalrecords = $getproducts->rowCount();
    $json_data = array('numofrows' => $totalrecords);

    if ($totalrecords > 0) {
        $nestedData = array();
        while ($row = $getproducts->fetch()) {
            $nestedData[] = $row;
        }
        $json_data['details'] = $nestedData;
    }

    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    echo json_encode(array('error' => $e->getMessage()));
    exit;
}
?>
