<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    //$userloggedid = $_SESSION["userid"];

    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $budgetid = filter_input(INPUT_POST, "budgetid"); 
   // $searchInput =  filter_input(INPUT_POST, "searchInput");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($budgetid)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "budget.budget_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "budget.budget_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }

   // if (!empty($searchInput)) {
   //     $conditions[] = "(users.names LIKE :search_key OR users.phone LIKE :search_key OR users.email LIKE :search_key)";
   //     $parameters[':search_key'] = '%' . $searchInput . '%';
   // }

    // Prepare the SQL query with the conditions
    $query = "SELECT COUNT(budget.budget_id) AS totalbudgets, 
              budget.budget_item,budget.budget, budget.variance_analysis, budget.analysis_file,
              variance_analysis_id,analysis_by, users.names 
              FROM budget 
              INNER JOIN users ON budget.analysis_by = users.id 
              WHERE budget.item_id = '$budgetid'";

    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " GROUP BY budget.variance_analysis_id ORDER BY budget.budget_date ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = []; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails)
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
