// ************************************************
// Shopping Cart API
// ************************************************

var shoppingCart = (function() {
  // =============================
  // Private methods and propeties
  // =============================
  cart = [];

  // Constructor
 function Item(name, price, count, id, productcode,category,categorycode,depot,depotid,depotcode, chargerate, duedate) {
    this.name = name;
    this.price = price;
    this.count = count;
    this.id = id;
    this.productcode = productcode;
    this.category = category;
    this.categorycode = categorycode;
    this.depot = depot;
    this.depotid = depotid;
    this.depotcode = depotcode;
    this.chargerate= chargerate;
    this.duedate= duedate;
  }
  // Save cart
  function saveCart() {
    sessionStorage.setItem('shoppingCart', JSON.stringify(cart));
  }
    // Load cart
  function loadCart() {
    cart = JSON.parse(sessionStorage.getItem('shoppingCart'));
  }
  if (sessionStorage.getItem("shoppingCart") != null) {
    loadCart();
  }
  // =============================
  // Public methods and propeties
  // =============================
  var obj = {};
  
  // Add to cart
  // Add to cart
  obj.addItemToCart = function(name, price, count, id, productcode, category, categorycode, depot, depotid, depotcode, chargerate, duedate) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart[item].count ++;
        saveCart();
        return;
      }
    }
    var item = new Item(name, price, count, id, productcode, category, categorycode, depot, depotid, depotcode, chargerate, duedate);
    cart.push(item);
    saveCart();
  }
  
  // Set count from item
  obj.setCountForItem = function(name, count) {
    for(var i in cart) {
      if (cart[i].name === name) {
        cart[i].count = count;
        break;
      }
    }
  };
  // Remove item from cart
  obj.removeItemFromCart = function(name) {
      for(var item in cart) {
        if(cart[item].name === name) {
          cart[item].count --;
          if(cart[item].count === 0) {
            cart.splice(item, 1);
          }
          break;
        }
    }
    saveCart();
  }

  // Remove all items from cart
  obj.removeItemFromCartAll = function(name) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart.splice(item, 1);
        break;
      }
    }
    saveCart();
  }

  // Clear cart
  obj.clearCart = function() {
    cart = [];
    saveCart();
  }
  // Count cart 
  obj.totalCount = function() {
    var totalCount = 0;
    for(var item in cart) {
      totalCount += cart[item].count;
    }
    return totalCount;
  }
  // Total cart
  obj.totalCart = function() {
    var totalCart = 0;
    for(var item in cart) {
      totalCart += cart[item].price * cart[item].count;
    }
    return Number(totalCart.toFixed(2));
  }
  // List cart
  obj.listCart = function() {
    var cartCopy = [];
    for(i in cart) {
      item = cart[i];
      itemCopy = {};
      for(p in item) {
        itemCopy[p] = item[p];

      }
      itemCopy.total = Number(item.price * item.count).toFixed(2);
      cartCopy.push(itemCopy)
    }
    return cartCopy;
  }

  // cart : Array
  // Item : Object/Class
  // addItemToCart : Function
  // removeItemFromCart : Function
  // removeItemFromCartAll : Function
  // clearCart : Function
  // countCart : Function
  // totalCart : Function
  // listCart : Function
  // saveCart : Function
  // loadCart : Function
  return obj;
})();


// *****************************************
// Triggers / Events
// ***************************************** 
// Add item

 $(document).on('click','#addInvoiceItem045',function (event){
    var name = $(this).data('name');
    var category = $(this).data('category');
    var price = Number($(this).data('price'));
    var id = ($(this).data('id'));
    var categorycode = ($(this).data('categorycode'));
    var productcode = ($(this).data('productcode'));

    var depot = $(this).data('depot');
    var depotid= ($(this).data('depotid'));
    var depotcode = ($(this).data('depotcode')); 
    var chargerate= ($(this).data('chargerate'));
    var duedate = ($(this).data('duedate'));
     //alert(category);alert(categorycode);alert(productcode);
   // alert('iam here');
   // alert(id);alert(name);alert(price);
    //var user_id = ($(this).data('userid'));
    //var productdeliverycharge = ($(this).data('deliverycharge'));
    //var lat = ($(this).data('lat'));
    //var lng = ($(this).data('lng'));
   // var distance = Number($(this).data('distance'));
   // var productdeliverycharge2 = distance*productdeliverycharge;
  //alert(depot); alert(depotid);alert(depotcode);
 
   shoppingCart.addItemToCart(name, price, 1, id, productcode, category, categorycode,depot,depotid,depotcode, chargerate, duedate);
  displayCart();
  $('#invoiceItemsList').append('<div class="invoiceItemDiv0" class="w3-col l12 m12 s12"><div class="w3-col l7 m7 s7"><span class="invoiceItemId" style="display:none;">'+id+'</span><span class="invoiceItemName" style="float:left;margin-left: 60px;font-weight:400;">'+name+'</span></div><div class="w3-col l2 m2 s2"><input class="invoiceUnits0" value="1" type="number" style="float:left;width:100%;height:20px;border:none;background-color:rgba(0,0,0,0.02);cursor:pointer;"/></div><div class="w3-col l1 m1 s1"><span class="invoiceItemPrice0" style="float:right;">'+price+'</span></div><div class="w3-col l2 m2 s2"><span class="invoiceItemTotalPrice0" style="float:right;margin-right:0px;">'+price+'</span></div></div>');
   
  var total = 0;
  $('.invoiceItemTotalPrice0').each(function(){
    total += parseFloat($(this).text().replace(/,/g,''))
  });
  
  //$('.total').text(total)
  //alert(total);
  $('#invoiceSubTotal').empty();
  $('#invoiceSubTotal').append(total);
  //invoiceTaxTotal0
  var taxPercent = total*0.10;
  $('#invoiceTaxTotal0').empty();
  $('#invoiceTaxTotal0').append(taxPercent);
  //invoiceTotal0
  var invoiceTotal = total-taxPercent;
  $('#invoiceTotal0').empty();
  $('#invoiceTotal0').append(invoiceTotal);
 

	$('#cart-count0').addClass('cart-count-style0');
	setTimeout(function(){
	  $('#bottom_toast345').fadeOut('slow'); 
	$('#bottom_toast345').empty(); 
	$('#cart-count0').removeClass('cart-count-style0');

	}, 2500);
  
});
 // add product delivery charge


// MAKE PAYMENT
$(document).on('click','.transact0',function (event) {
  transact101();
})
function transact101(){
  //alert('iam trasact');	
  $('#transact_modal').fadeIn('slow');
 // addInvoicedItem();
  $('#payment-btns01').empty();
  $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MAKE MOMO TRANSACTION</div></center>');
  $('#paymentresponseDivBottom').empty(); 
  $('#addInvoicedItemDiv').empty();
  $('#addInvoicedItemDiv').append('<span  id="addInvoicedItem0" style="float:left;cursor: pointer;">Product/Service <span class="fontx fx-plus" style="color:rgba(96, 146, 205,1);cursor: pointer;"></span></span>');
  $('#addInvoiceClientDiv').empty();
  $('#addInvoiceClientDiv').append('<button type="button" id="addInvoiceClient0" style="float:left;font-weight:600;color:rgba(96, 146, 205,1);height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button>');
 
  $('.bankAccoutDiv101').fadeOut('slow'); 
  $('.modeOfPaymentDiv0').fadeIn('slow');
  $('#modeOfPayment').empty(); 
 $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="CASH">Cash payment</option><option value="BANK">Bank Deposit</option>'); 
  
  $('#invoiceType').empty();
  $('#invoiceType').append('<option value="RECEIPT"> RECEIPT</option><option value="INVOICE">INVOICE</option><option value="QUOTATION">QUOTATION</option>');
  
  $('#invoiceDueDateDiv').empty();
  $('#invoiceDueDateDiv').append('<input id="invoiceDueDate" type="date" placeholder="Date" style="margin-left:10px;margin-top:0px;float:left;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;" readonly/>');       

  // empty the print div
  $('#printReceiptDiv102').empty();
  
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
  //$('#invoiceNumber').empty();
  //$('#invoiceNumber').append(randReceipt);
 // let today = new Date().toLocaleDateString();
  document.getElementById('invoiceDueDate').value ='';
  //document.getElementById('invoiceDueDate').value = today;
//payment-btns01
//paymentresponseDivBottom
$('#paymentresponseDivBottom').show();
$('#payment-btns01').show();


}

$(document).on('click','.close_transact_modal',function (event) {
	 event.preventDefault();
    event.stopPropagation(); 
    $('#transact_modal').fadeOut('slow');
     $('#invoiceNumber').empty();
   $('#invoicedClientName0').empty();
   $('#invoicedClientAddress0').empty();
   $('#invoicedClientEmail0').empty();
   $('#invoicedClientId0').empty();
   $('#payment-btns01').empty(); 
   $('#payment-btns01').append('<center><div class="cashTransact01 w3-col" style="font-weight: 600;height:35px;line-height: 30px;">Make cash  transaction</div></center>'); 
   $('#paymentresponseDivBottom').empty(); 
  
   $('#paymentresponseDivBottom').empty();

   $('#plotnumber07').empty();
   $('#area07').empty();
   $('#nrc07').empty();
   document.getElementById('invoiceDueDate').value ='';
	 document.getElementById('trasactionTime34').value ='';
   document.getElementById('invoicedClientPhone0').value ='';
	 document.getElementById('invoiceDueDate').value ='';
    shoppingCart.clearCart();
    displayCart(); 
	       
});
// Clear items
$('.clear-cart').click(function() {
  shoppingCart.clearCart();
  displayCart();
});
// Delete item button

$(document).on("click", ".delete-item", function(event) {
	//alert('Hello');
  var name = $(this).data('name');
  shoppingCart.removeItemFromCartAll(name);
  displayCart();
})
 
// Item count input 
$('.show-cart').on("keyup", ".item-count", function(event) {
   var name = $(this).data('name');
   var count = Number($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart(); 
});

$('.show-cart').on("change", ".item-count", function(event) {
   var name = $(this).data('name');
   var count = Number($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart(); 
});

function displayCart() {
  var cartArray = shoppingCart.listCart();
  var output = "";
  for(var i in cartArray) {
    output+="<div class='w3-col l12 m12 s12' style='float:left;padding-left:0px;'>"
      +"<div class='w3-col l6 m6 s7' style='float:left;padding-left:5px;text-align:left;'>"+cartArray[i].name+"</div>" 
      +"<div class='w3-col l2 m2 s2' style='float:left;'>K"+cartArray[i].price+"</div>"
      +"<div class='w3-col l1 m1 s1' style='border-right:none;'><div class='input-group'>"
      +"<input type='number' step='0.1' class='item-count form-control' data-name='"+cartArray[i].name+"' value='"+cartArray[i].count+"' style='max-width:40px;border:none;font-size:0.7em'>"
     +"</div></div>"
     +"<div class='w3-col l1 m1 s1 w3-hide-small' style='float:left;'>0.00</div>"
     +"<div class='w3-col l2 m2 s2'><b style='color:gray;'>"+cartArray[i].total+"</b></div>" 
   //  +"<div class='w3-col l1 m1 s1 w3-hide-small' style='float:left;'>0.00</div>"
    
	// + "<div class='w3-col l1 m1 s1' style='background-color:purple;'><span class='delete-item fontx fx-trash-2' data-name=" + cartArray[i].name + "></span></div>"
      
      +"</div>";
	 //alert(cartArray[i].id); 
	 //alert(cartArray); 

	  
  }
  
  	// var json = JSON.stringify(cartArray);
    // alert(json);
	 
  $('.show-cart').html(output);
  $('.total-cart').html(shoppingCart.totalCart());
  $('.total-count').html(shoppingCart.totalCount());
  
   //alert(output);
    
}
 
displayCart();

var orderDetails = JSON.stringify(cart);
 
 
    // selectig mode of paymet
     $(document).on('change keyup','#modeOfPayment',function (event) {
	   var modeOfPayment = $("#modeOfPayment").val(); 
        
      if(modeOfPayment=="CASH"){
        //   $('.dropdown').show();
          $('#payment-btns-div01').show();
          $('#payment-btns01').empty();
          $('#payment-btns01').append('<center><div class="cashTransact01 w3-col" style="font-weight: 600;height:35px;line-height: 30px;">MAKE CASH TRANSACTION</div></center>');
        //  $('.paymentBtnsDiv012').empty();
        // $('.paymentBtnsDiv012').append('<div class="cashTransact01" style="font-weight: 600;height:30px;line-height: 30px;float:right;background-color:#eee;color:rgba(96, 146, 205,1);margin-top:3px;margin-right:12px;border-radius:3px;padding-right:5px; padding-left:5px;cursor:pointer"> Cash Trasact</div>');
        $('#bankNameDiv0').hide();
        $('#bankDepositSlipIdDiv').hide();
        }else if(modeOfPayment=="BANK"){
               
          $('#bankName').empty();
          $('#bankName').append('<option>Select bank </option><option value="Zanaco main account">Zanaco main account</option><option value="Zanaco Development Account">Zanaco Development A/C</option><option value="Indo transit account">Indo transit account </option><option value="Indo Fire Account">Indo Fire Account</option><option value="Indo Waste Account">Indo Waste Account</option><option value="Indo Capital Account">Indo Capital Account</option><option value="Airtel money account">Airtel money account</option><option value="MTN Money Account">MTN Money Account</option>');
          $('#payment-btns-div01').show();
          $('#payment-btns01').empty();
          $('#payment-btns01').append('<center><div class="bankTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MAKE BANK TRANSACTION</div></center>');
          $('#bankNameDiv0').fadeIn('slow');
          $('#bankDepositSlipIdDiv').fadeIn('slow');
            }else if(modeOfPayment=="MOMO"){
              
              $('#payment-btns-div01').show();
              $('#payment-btns01').empty();
              $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MAKE MOMO TRANSACTION</div></center>');
              $('#bankNameDiv0').hide();
              $('#bankDepositSlipIdDiv').hide();
            }
    });

$(document).on('change keyup','#invoiceType',function (event) {
  //var report = $("#reports101 option:selected" ).text();
  var invoiceType = $("#invoiceType").val(); 
  let today = new Date().toISOString().slice(0,10).replace(/-/g, "/");
 // alert(today);
		 if(invoiceType=="INVOICE"){
    //   $('.dropdown').show();
    //  $('#billingCycle').show();
    //  $('#payment-btns01').hide();
     //   $('#print_invoice').show();
        $('#payment-btns01').empty();
         $('#payment-btns01').append('<center><div id="createInvoice0" style="font-weight: 600;height:35px;line-height: 30px;">CREATE INVOICE</div></center>');
        $('#invoiceDueDateDiv').empty();
        $('#invoiceDueDateDiv').append('<input id="invoiceDueDate" value="'+today+'" style="margin-left:10px;margin-top:0px;float:left;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;"/>');       
        $('.modeOfPaymentDiv0').fadeOut('slow');
        $('#bankDepositSlipIdDiv').fadeOut('slow');
        $('#bankNameDiv0').fadeOut('slow');
        $('.bankAccoutDiv101').fadeIn('slow'); 
        $('.invoiceApproval101').fadeIn('slow'); 
        }else if(invoiceType=="QUOTATION"){
           $('#payment-btns01').empty();
           $('#payment-btns01').append('<center><div id="createQuotation0" style="font-weight: 600;height:35px;line-height: 30px;">CREATE QUOTATION</div></center>');
           $('#invoiceDueDateDiv').empty();
           $('#invoiceDueDateDiv').append('<input id="invoiceDueDate" value="'+today+'" style="margin-left:10px;margin-top:0px;float:left;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;"/>');       
           $('.modeOfPaymentDiv0').fadeOut('slow');
           $('#bankDepositSlipIdDiv').fadeOut('slow');
           $('#bankNameDiv0').fadeOut('slow');
           $('.bankAccoutDiv101').fadeIn('slow'); 
           $('.invoiceApproval101').fadeOut('slow');
          }else if(invoiceType=="RECEIPT"){
          $('#payment-btns-div01').show();
          $('#payment-btns01').empty();
          $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MOBILE MONEY TRANSACT</div></center>');
         $('#bankNameDiv0').hide();
          $('#bankDepositSlipIdDiv').hide();
          $('#invoiceDueDateDiv').empty();
          $('#invoiceDueDateDiv').append('<input id="invoiceDueDate" placeholder="Date" style="margin-left:10px;margin-top:0px;float:left;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;" readonly/>');       
          $('.modeOfPaymentDiv0').fadeIn('slow');
          $('.bankAccoutDiv101').fadeOut('slow'); 
          $('.invoiceApproval101').fadeOut('slow');
 
        
        }
});


// CREATE INVOICE 
// CREATE INVOICE 
$(document).on('click', '#createInvoice0', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  var amount = $('.total-cart').html();
  var userid = $("#invoicedClientId0").html();
  var fname = $("#invoicedClientName0").val();
  var lname =  $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone =  $("#invoicedClientPhone0").val();
  var invoiceNumber= $("#invoiceNumber").html();
  var invoiceDueDate= $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
 if(phone != '' && cartlistDetails != '' && nrc !='')
 {
    datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
   
 $.ajax({    
     data:datastring,
 url: "xd-modules/cashier-module/billing/backend/createInvoice.php",
     type: "POST"	
   
 }).done (function(data) {
  var response = JSON.parse(data);

  if(response.status=='created'){
    invoicesByClient();
   $("#topInvoiceNavContents").hide();
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(response.receiptnumber);
  document.getElementById('invoiceDueDate').value ='';
  document.getElementById('invoiceDueDate').value =response.date;
  document.getElementById('trasactionTime34').value = '';
  document.getElementById('trasactionTime34').value = response.time;
   $("#payment-btns01").empty(); 
   $("#payment-btns01").hide();
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   setTimeout(function(){ 
   window.print(); 
   }, 100);
   
   setTimeout(function(){ 
   $("#topInvoiceNavContents").show();
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
   }, 700);

  // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
 // $('#paymentresponseDivTop').fadeOut();


  }else{
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');

  }
   //console.log(newdata.transactionReference);   
}); 	

}
else
{
   //location.reload();
    alert('Please enter phone number and nrc!');
}


}); 
// CREATE INVOICE 
// CREATE INVOICE 


// CREATE INVOICE 
// CREATE INVOICE 
$(document).on('click', '#createQuotation0', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  var amount = $('.total-cart').html();
  var userid = $("#invoicedClientId0").html();
  var fname = $("#invoicedClientName0").val();
  var lname =  $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone =  $("#invoicedClientPhone0").val();
  var invoiceNumber= $("#invoiceNumber").html();
  var invoiceDueDate= $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
 if(phone != '' && cartlistDetails != '' && nrc !='')
 {
    datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
   
 $.ajax({    
     data:datastring,
 url: "xd-modules/cashier-module/billing/backend/createQuotation.php",
     type: "POST"	
   
 }).done (function(data) {
  var response = JSON.parse(data);

  if(response.status=='created'){
    quotationByClient();
   $("#topInvoiceNavContents").hide();
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(response.receiptnumber);
  document.getElementById('invoiceDueDate').value ='';
  document.getElementById('invoiceDueDate').value =response.date;
  document.getElementById('trasactionTime34').value = '';
  document.getElementById('trasactionTime34').value = response.time;
   $("#payment-btns01").empty(); 
   $("#payment-btns01").hide();
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   setTimeout(function(){ 
   window.print(); 
   }, 100);
   
   setTimeout(function(){ 
   $("#topInvoiceNavContents").show();
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
   }, 700);

  // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
 // $('#paymentresponseDivTop').fadeOut();


  }else{
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');

  }
   //console.log(newdata.transactionReference);   
}); 	

}
else
{
   //location.reload();
    alert('Please enter phone number and nrc!');
}


}); 
// CREATE QUOTATION
// CREATE QUOTATION


$(document).on('click','#closeInvoiceProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
 $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  $('.dropdown').show();
  $('#billingCycle').show();
  $('#payment-btns01').hide();
    $('#print_invoice').show();
    $('#payment-btns-div01').append('<div id="createInvoice0" class="w3-col l12 m12 s12" style="color:white;"> <span><a href="#" id="print_invoice"  class="fontx fx-printer" onclick="window.print()" style="margin-top:10px;margin-right: 10px;float:right;display: none;color: gray;"></a></span>Submit</div>');
  
  //clear-cart
  //shoppingCart.clearCart();
  //displayCart();
  var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 $('#invoiceNumber').empty();
 $('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});

// close large modal
$(document).on('click','.closeLargeModal99',function (event) {
  $('#tempDiv00').remove();
  $('#generalmodalLarge').fadeOut();
 $('#generalmodalLargeMainDiv').show();
});

//bankrefid
$(document).on('click', '.bankdepositslip0', function(event){
  event.preventDefault();
  event.stopPropagation();
  var bankname = $(this).data('bankname');
  var bankaccountname = $(this).data('bankaccountname');
  var bankdepositslip = $(this).data('bankdepositslip');
  var bankdepositid = $(this).data('bankdepositid');
  $('#generalmodalLarge').fadeIn('slow');
  $('#div_title342').empty();
	$('#div_title342').append('<h4 style="margin-top:-7px;font-weight:600;">DEPOSIT SLIP DETAILS</h4>');
	$('#div_body342').empty();
  $('#div_body342').append('<b>'+bankname+'</b>: <span>'+bankaccountname+'</span><br/>');
  $('#div_body342').append('<b>Referece Id</b>: <span>'+bankdepositid+'</span>');
  $('#div_body342').append('<img src="xd-uploads/documents/deposits-slips/'+bankdepositslip+'" style="margin-top:20px;height:500px;width:100%;"/>');
  //$('#div_body342').append('<p id="closeModal876" style="background-color:transparent;color:green;height:35px;line-height:30px;width:100px;border-radius:15px;border:2px solid green;font-weight:600;cursor:pointer;">Send</p>');

});

// MAKIG PAYMET FOR DUE IVOICES

$(document).on('click', '#invoiceMakePayment0', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  $('#transact_modal').fadeIn('slow');
  $('#invoiceType').empty();
  $('#invoiceType').append('<option value="INVOICE">INVOICE</option>');
//  $('#invoiceType').append('<option value="INVOICE">INVOICE</option><option value="QUOTATION">QUOTATION</option><option value="RECEIPT">RECEIPT</option>');
 
   // empty the print div
   $('#printReceiptDiv102').empty();
  $('.modeOfPaymentDiv0').fadeIn('slow');
  $('#modeOfPayment').empty(); 
  $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="CASH">Cash Payment</option><option value="BANK">Bank Deposit</option>'); 
  $("#topInvoiceNavContents").show();
  $('#printReceiptDiv102').empty();
  $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
 
  $('#paymentresponseDivBottom').empty();
  $('#payment-btns01').show();
  $('#payment-btns01').empty();
  $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MAKE MOMO TRANSACTION</div></center>');
  
    var clientname = $(this).data('names');
    var companyname = $(this).data('companyname');
  // alert(companyname);
    var phone = $(this).data('phone');
     var email = $(this).data('email');
    var address = $(this).data('address');
    var userid = $(this).data('userid');
    var pacra =$(this).data('pacra');
    var plotnumber =$(this).data('plotnumber');
    var area = $(this).data('area');
    var nrc = $(this).data('nrc'); 
     var tpin =$(this).data('tpin');
    var businessCategory=$(this).data('businesscategory');
   var invoiceNumber = $(this).data('invoicenumber');
   var duedate = $(this).data('duedate');
   // alert(invoiceNumber);
   // gettigivoices for the user
     shoppingCart.clearCart();  

	 datastring='userid='+userid+'&invoiceNumber='+invoiceNumber;
	 
	 $.ajax({         
		data:datastring,
	url: "xd-modules/cashier-module/billing/backend/getUserInvoiceItems.php",
		type: "POST"
  
   }).done (function(data) {

    	var detailsx = JSON.parse(data);
	  $.each(detailsx.details, function(i,cyberdesk) {
   
  //alert(cyberdesk.category); alert(cyberdesk.category_code);
    shoppingCart.addItemToCart(cyberdesk.product_name,cyberdesk.balance,cyberdesk.units,cyberdesk.product_id,cyberdesk.product_code,cyberdesk.category,cyberdesk.category_code,cyberdesk.depot,cyberdesk.depot_id,cyberdesk.depot_code);
    displayCart(); 
	});
	
  });


  //$('#addInvoicedItemDiv').empty();
  //$('#addInvoicedItemDiv').append('<span style="float:left;margin-left:60px;cursor: pointer;">ITEM </span>');
  $('#addInvoiceClientDiv').empty();
  $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
  document.getElementById('invoicedClientName0').value='';
	if(companyname==''){
       document.getElementById('invoicedClientName0').value=clientname;
	}else{
	  document.getElementById('invoicedClientName0').value=companyname;
	}
  $('#invoicedClientName1').empty();
  $('#invoicedClientName1').append(clientname);
  document.getElementById('invoicedClientAddress0').vallue='';
  document.getElementById('invoicedClientAddress0').value=address;
  document.getElementById('plotnumber07').value='';
  document.getElementById('plotnumber07').value=plotnumber;
  document.getElementById('area07').value='';
  document.getElementById('area07').value=area;
  document.getElementById('nrc07').value='';
  document.getElementById('nrc07').value=nrc;
  document.getElementById('invoicedClientEmail0').value='';
  document.getElementById('invoicedClientEmail0').value=email;
  $('#invoicedClientId0').empty();
  $('#invoicedClientId0').append(userid);
  $('#pacra00').empty();
  $('#pacra00').append(pacra); 
  $('#tpin00').empty();
  $('#tpin00').append(tpin); 
  $('#businesscategory00').empty();
  $('#businesscategory00').append(businessCategory); 
  document.getElementById('invoicedClientPhone0').value ='';
  document.getElementById('invoicedClientPhone0').value = phone;
 // let today = new Date().toLocaleDateString();
  document.getElementById('invoiceDueDate').value =''; 
  document.getElementById('invoiceDueDate').value =duedate; 
  $('#invoiceNumber').empty();
  $('#invoiceNumber').append(invoiceNumber);
 


});

$(document).on('click', '#quotationMakePayment0', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  $('#transact_modal').fadeIn('slow');
  $('#invoiceType').empty();
  $('#invoiceType').append('<option value="INVOICE">QUOTATION</option>');
//  $('#invoiceType').append('<option value="INVOICE">INVOICE</option><option value="QUOTATION">QUOTATION</option><option value="RECEIPT">RECEIPT</option>');
 
   // empty the print div
   $('#printReceiptDiv102').empty();
  $('.modeOfPaymentDiv0').fadeOut('slow');
 // $('#modeOfPayment').empty(); 
 // $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="CASH">Cash Payment</option><option value="BANK">Bank Deposit</option>'); 
  $("#topInvoiceNavContents").show();
  $('#printReceiptDiv102').empty();
  $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
 
  $('#paymentresponseDivBottom').empty();
  $('#payment-btns01').show();
 // $('#payment-btns01').empty();
 // $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MAKE MOMO TRANSACTION</div></center>');
  $('#payment-btns01').empty();
  $('#payment-btns01').append('<center><div id="createQuotationAsInvoice0" style="font-weight: 600;height:35px;line-height: 30px;">CREATE AS INVOICE TO PAY</div></center>');
   
  var clientname = $(this).data('names');
    var companyname = $(this).data('companyname');
  // alert(companyname);
    var phone = $(this).data('phone');
     var email = $(this).data('email');
    var address = $(this).data('address');
    var userid = $(this).data('userid');
    var pacra =$(this).data('pacra');
    var plotnumber =$(this).data('plotnumber');
    var area = $(this).data('area');
    var nrc = $(this).data('nrc'); 
     var tpin =$(this).data('tpin');
    var businessCategory=$(this).data('businesscategory');
   var invoiceNumber = $(this).data('invoicenumber');
   var duedate = $(this).data('duedate');
   // alert(invoiceNumber);
   // gettigivoices for the user
     shoppingCart.clearCart();  

	 datastring='userid='+userid+'&invoiceNumber='+invoiceNumber;
	 
	 $.ajax({         
		data:datastring,
	url: "xd-modules/cashier-module/billing/backend/getUserQuotationItems.php",
		type: "POST"
  
   }).done (function(data) {

    	var detailsx = JSON.parse(data);
	  $.each(detailsx.details, function(i,cyberdesk) {
   
   // alert(cyberdesk.billing_interval); alert(cyberdesk.due_date);
    shoppingCart.addItemToCart(cyberdesk.product_name,cyberdesk.balance,cyberdesk.units,cyberdesk.product_id,cyberdesk.product_code,cyberdesk.category,cyberdesk.category_code,cyberdesk.depot,cyberdesk.depot_id,cyberdesk.depot_code,cyberdesk.billing_interval,cyberdesk.due_date);
    displayCart(); 
	});
	
  });


  //$('#addInvoicedItemDiv').empty();
  //$('#addInvoicedItemDiv').append('<span style="float:left;margin-left:60px;cursor: pointer;">ITEM </span>');
  $('#addInvoiceClientDiv').empty();
  $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
  document.getElementById('invoicedClientName0').value='';
	if(companyname==''){
       document.getElementById('invoicedClientName0').value=clientname;
	}else{
	  document.getElementById('invoicedClientName0').value=companyname;
	}
  $('#invoicedClientName1').empty();
  $('#invoicedClientName1').append(clientname);
  document.getElementById('invoicedClientAddress0').vallue='';
  document.getElementById('invoicedClientAddress0').value=address;
  document.getElementById('plotnumber07').value='';
  document.getElementById('plotnumber07').value=plotnumber;
  document.getElementById('area07').value='';
  document.getElementById('area07').value=area;
  document.getElementById('nrc07').value='';
  document.getElementById('nrc07').value=nrc;
  document.getElementById('invoicedClientEmail0').value='';
  document.getElementById('invoicedClientEmail0').value=email;
  $('#invoicedClientId0').empty();
  $('#invoicedClientId0').append(userid);
  $('#pacra00').empty();
  $('#pacra00').append(pacra); 
  $('#tpin00').empty();
  $('#tpin00').append(tpin); 
  $('#businesscategory00').empty();
  $('#businesscategory00').append(businessCategory); 
  document.getElementById('invoicedClientPhone0').value ='';
  document.getElementById('invoicedClientPhone0').value = phone;
 // let today = new Date().toLocaleDateString();
  document.getElementById('invoiceDueDate').value =''; 
  document.getElementById('invoiceDueDate').value =duedate; 
  $('#invoiceNumber').empty();
  $('#invoiceNumber').append(invoiceNumber);
 
});

//create Quotation As Invoice
//create Quotation As Invoice
//create Quotation As Invoice
$(document).on('click', '#createQuotationAsInvoice0', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  var amount = $('.total-cart').html();
  var userid = $("#invoicedClientId0").html();
  var fname = $("#invoicedClientName0").val();
  var lname =  $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone =  $("#invoicedClientPhone0").val();
  var invoiceNumber= $("#invoiceNumber").html();
  var invoiceDueDate= $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
 if(phone != '' && cartlistDetails != '' && nrc !='')
 {
    datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
   
 $.ajax({    
     data:datastring,
 url: "xd-modules/cashier-module/billing/backend/createQuotationAsInvoice.php",
     type: "POST"	
   
 }).done (function(data) {
  var response = JSON.parse(data);

  if(response.status=='created'){
    invoicesByClient();
   $("#topInvoiceNavContents").hide();
   $('#invoiceType').empty();
   $('#invoiceType').append('<option value="INVOICE">INVOICE</option>');
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(response.receiptnumber);
  document.getElementById('invoiceDueDate').value ='';
  document.getElementById('invoiceDueDate').value =response.date;
  document.getElementById('trasactionTime34').value = '';
  document.getElementById('trasactionTime34').value = response.time;
   $('.modeOfPaymentDiv0').fadeIn('slow');
  $('#modeOfPayment').empty(); 
  $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="CASH">Cash Payment</option><option value="BANK">Bank Deposit</option>'); 
 
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   $("#payment-btns01").empty(); 
   setTimeout(function(){ 
   $('#paymentresponseDivBottom').empty();
   $('#payment-btns01').show();
   $('#payment-btns01').empty();
   $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">MAKE MOMO TRANSACTION</div></center>');
   
  // window.print(); 
  // $('#transact_modal').fadeOut('slow');
   }, 300);
   
   setTimeout(function(){ 
   $("#topInvoiceNavContents").show();
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
   }, 700);

  // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
 // $('#paymentresponseDivTop').fadeOut();


  }else{
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');

  }
   //console.log(newdata.transactionReference);   
}); 	

}
else
{
   //location.reload();
    alert('Please enter phone number and nrc!');
}


}); 
// create Quotation As Invoice
//create Quotation As Invoice
//create Quotation As Invoice

// invoicePayment0
$(document).on('click','.reprintReceipt0',function (event) { 
  // alert('Reprint charge @K20 will apply!');
   event.preventDefault();
   event.stopPropagation(); 
   $('#transact_modal').fadeIn('slow');
   $('#invoiceType').empty();
   $('#invoiceType').append('<option value="REPRINT"> RECEIPT <span style="color:red;"> (REPRINT)</span></option>');
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
  
   var invoicenumber = $(this).data('invoicenumber');
   var payment_mode = $(this).data('paymentmode');
   var bankname = $(this).data('bankname');
   var bankdepositslip = $(this).data('bankdepositslip');

   if(payment_mode=='CASH'){ 
$('#modeOfPayment').empty();
$('#modeOfPayment').append('<option value="CASH">Cash</option>');

   }else if(payment_mode=='BANK'){
    $('#modeOfPayment').empty();
    $('#modeOfPayment').append('<option value="BANK">Bank Deposit</option>');
    $('#bankName').empty();
    $('#bankName').append('<option value="'+bankname+'">'+bankname+'</option>');
     document.getElementById('bankDepositSlipId').value ='';
    document.getElementById('bankDepositSlipId').value = bankdepositslip;

   }

   shoppingCart.clearCart();
   $('.'+invoicenumber+'').each(function() { 
   // alert(productname2);
    var id = $(this).data('productid'); 
    var name = $(this).data('productname');
    var price = $(this).data('productprice');
   ///alert(id);alert(name);alert(price);
   
    var category = ($(this).data('category'));
      var categorycode = ($(this).data('categorycode'));
    var productcode = ($(this).data('productcode'));
    var depot = $(this).data('depot');
    var depotid= ($(this).data('depotid'));
    var depotcode = ($(this).data('depotcode'));  
 
   shoppingCart.addItemToCart(name, price, 1, id,  productcode, category, categorycode,depot,depotid,depotcode);
  displayCart();
  
    shoppingCart.addItemToCart(name, price, 1, id);

    displayCart();
 
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(invoicenumber);
     var clientname = $(this).data('names');
     var companyname = $(this).data('companyname');
     var phone = $(this).data('phone');
     var email = $(this).data('cemail');
     //alert(email);
     var address = $(this).data('address');
     var userid = $(this).data('userid');
     var transactiontime = $(this).data('transactiontime');
     var transactiondate = $(this).data('transactiondate');
     
    var pacra =$(this).data('pacra');
     var plotnumber =$(this).data('plotnumber');
     var area = $(this).data('area');
     var nrc = $(this).data('nrc');
     var tpin =$(this).data('tpin');
     var businessCategory=$(this).data('businesscategory');
    
   $('#productid').empty();
   $('#productid').append(id);
   $('#addInvoicedItemDiv').empty();
   $('#addInvoicedItemDiv').append('<span style="float:left;cursor: pointer;">Product/Service </span>');
   $('#addInvoiceClientDiv').empty();
   $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
  // document.getElementById('invoicedClientName0').value='';
   if(companyname==''){
        //document.getElementById('invoicedClientName0').value=clientname;
        $('.invoicedClientName0Div').empty();
        $('.invoicedClientName0Div').append('<input id="invoicedClientName0" value="'+clientname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
        
   }else{
    // document.getElementById('invoicedClientName0').value=companyname;
     $('.invoicedClientName0Div').empty();
     $('.invoicedClientName0Div').append('<input id="invoicedClientName0" value="'+companyname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
    }

   $('#invoicedClientName1').empty();
   $('#invoicedClientName1').append(clientname);
   $('.plotnumber07Div').empty();
   $('.plotnumber07Div').append('<input id="plotnumber07" value="'+plotnumber+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;width:100px;" readonly/>');
   $('.plotnumber07Div').append('<input id="invoicedClientAddress0" value="'+address+'" type="address" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
   $('.plotnumber07Div').append('<input id="area07" value="'+area+'" type="text" class="w3-hide-small" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
  // $('#invoicedClientAddress0').empty();
   //$('#invoicedClientAddress0').append(address);
  // $('#plotnumber07').empty();
  // $('#plotnumber07').append(plotnumber);
  // $('#area07').empty();
  // $('#area07').append(area); 
   
   $('.nrc07Div').empty();
    $('.nrc07Div').append('<input id="nrc07" value="'+nrc+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;" readonly/>');
    //$('#nrc07').empty();
   //$('#nrc07').append(nrc);

  // $('#invoicedClientEmail0').empty();
  // $('#invoicedClientEmail0').append(email); 
   $('.invoicedClientEmail0Div').empty();
   $('.invoicedClientEmail0Div').append('<input id="invoicedClientEmail0" value="'+email+'" type="email"  style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
   $('.invoicedClientEmail0Div').append('<input id="invoicedClientPhone0" value="'+phone+'" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;" readonly/>');
    
   $('#invoicedClientId0').empty();
   $('#invoicedClientId0').append(userid);
   $('#pacra00').empty();
   $('#pacra00').append(pacra); 
   $('#tpin00').empty();
   $('#tpin00').append(tpin); 
   $('#businesscategory00').empty();
   $('#businesscategory00').append(businessCategory); 
   //document.getElementById('invoicedClientPhone0').value ='';
  // document.getElementById('invoicedClientPhone0').value = phone;

   document.getElementById('invoiceDueDate').value ='';
   document.getElementById('invoiceDueDate').value = transactiondate;
   document.getElementById('trasactionTime34').value ='';
   document.getElementById('trasactionTime34').value = transactiontime;

  });
  // GETTIG REPRIT CHARGE

  $.getJSON('xd-modules/cashier-module/backend/reprintCharge.php',function(data){
  $('#paymentresponseDivBottom').empty();
    $('#payment-btns01').show();
    $('#payment-btns01').empty();
     $.each(data.freelancedetails, function(i,cyberdesk) {
    $('#payment-btns01').append('<center><div id="cashReprintTransact0" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.name+'" data-productcode="'+cyberdesk.product_code+'" data-price="'+cyberdesk.price+'" style="font-weight: 600;height:35px;line-height: 30px;">Click To Re-print (@ K'+cyberdesk.price+')</div></center>');
     
  });
   
      });

});

$(document).on('click','#reverseTransaction0',function (event) {
	event.preventDefault();
   event.stopPropagation();
   alert('Reversal not activated');
});

  //paymentresponseDivBottom

  $(document).on('click','.printDivOnClick',function (event){
     window.print();

    //shoppingCart.clearCart();
   // $('#transact_modal').fadeOut('slow');
  //  $("#paymentresponseDivTop").empty();
   // $("#paymentresponseDivTop").hide();
  // $("#paymentresponseDivBottom").empty();
  //  $("#paymentresponseDivBottom").hide();
    $("#topInvoiceNavContents").show();
    $("#payment-btns01").empty();
    $("#payment-btns01").hide();
   // $('#plotnumber07').empty();
   //$('#area07').empty();
   // $('#nrc07').empty();
  //  document.getElementsByClassName('carddetailsinput').value ='';
    //clear-cart
    //shoppingCart.clearCart();
    //displayCart();

    setTimeout(function(){
     //location.reload(); 
    // $("#paymentresponseDivBottom").empty();
     // $("#paymentresponseDivBottom").hide();
     $("payment-btns01").show();
     $("paymentresponseDivBottom").hide();
      //document.getElementById('invoiceDueDate').value ='';
      //document.getElementById('invoiceDueDate').value = today;
      $('#printReceiptDiv102').empty();
      $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
     
    }, 800);
  

  });

  // MOMO TRANSACTION

  $(document).on('click', '.momoTransact0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var amount = $('.total-cart').html();
    var userid = $("#invoicedClientId0").html();
    var fname = $("#invoicedClientName0").val();
    var lname =  $("#invoicedClientName1").html();
    var email = $("#invoicedClientEmail0").val();
    var productid = $("#productid").html();
    var deliveryaddress = $("#invoicedClientAddress0").val();
    var pacra = $("#pacra00").html(); 
    var tpin = $("#tpin00").html(); 
    var businessCategory = $("#businesscategory00").html();
    var plotnumber = $("#plotnumber07").val(); 
    var area = $("#area07").val(); 
    var nrc = $("#nrc07").val();
    var transtype = $("#invoiceType").val();
    var phone =  $("#invoicedClientPhone0").val();
    var invoiceNumber= $("#invoiceNumber").html();
    var invoiceDueDate= $("#invoiceDueDate").val();
    var deliverylat = $('#lat0').val();
    var deliverylng = $('#lng0').val();   
    var cartlist = shoppingCart.listCart();
    var cartlistDetails = JSON.stringify(cartlist);
    

		if(phone != '' && cartlistDetails != '' && nrc !='')
		{
      datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
		   
	    $.ajax({
				 					
	        data:datastring,
			url: "xd-modules/payment-processing/momoPay.php",
	        type: "POST"	
				
	    }).done (function(data) {
			  
			 var newdata = JSON.parse(data);
			
    $("#topInvoiceNavContents").hide();
    $("#payment-btns01").hide(); 
    $("#paymentresponseDivTop").show();
    $("#paymentresponseDivTop").append('<center><span class="w3-col l12 s12 m12" style="color:black;font-weight:600;" id="topResponse98" class="w3-animate-fading">Please wait!</span><span class="w3-col l12 s12 m12" style="color:black;font-weight:600;"> <span id="transactioReferenceStorage01"></span></span></center>');
    $("#paymentresponseDivBottom").empty();
    $("#paymentresponseDivBottom").show();
    $("#paymentresponseDivBottom").append('<center><div id="container_count_down">Wait for prompt in: <div id="countdown"><span id="timer"></span></div></center>');
   
    function cntDown() {
      let sec = 45;
      const el = document.getElementById("timer");
      const timer = setInterval(() => {
        el.innerHTML = sec--;
        if (sec < 15) el.style.color = "#ff0";
        if (sec < 7) el.style.color = "#f00";
        if (sec < 0){
          clearInterval(timer);
          $("#paymentresponseDivBottom").empty();
          $("#paymentresponseDivBottom").append('<center><a href="" style="width:100%;height:30px;">Click to try again!</a></center>');
         
        }
      }, 1000);
    }
   
    cntDown();
    
			 $('#transactioReferenceStorage01').empty();
			 $('#transactioReferenceStorage01').append(newdata.transactionReference);
			 //var reference = ;
			 
			 
	 setInterval(function(){
                
                      var tref = $('#transactioReferenceStorage01').html();
		
                   if(tref != ''){
					 
						datastring='tref='+tref;

						$.ajax({

						data:datastring,
						url: "xd-modules/payment-processing/verifyPayment.php",
						type: "POST"	

						}).done (function(data) {

						 var newdata = JSON.parse(data);
						 
						  //alert(data);
                          // alert(newdata.transaction_status);
						  
							$.each(newdata.details, function(i,cyberdesk) {
 
     if(cyberdesk.transaction_status == 'approved'){
 
      $("#paymentresponseDivTop").show();
      $("#topResponse98").empty();
     $("#transactioReferenceStorage01").empty();
     $("#topResponse98").remove();
     $("#transactioReferenceStorage01").remove();

     $("#paymentresponseDivBottom").empty();
     $("#paymentresponseDivBottom").show();
     $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:30px;">Success. Print receipt!</span></center>');
       $("#topResponse98").empty();
    
       $('#invoiceType').empty();
       $('#invoiceType').append('<option value="RECEIPT">RECEIPT</option>');
      $("#topInvoiceNavContents").hide();
      $('#invoiceNumber').empty();
      $('#invoiceNumber').append(cyberdesk.receipt_no);
     document.getElementById('invoiceDueDate').value ='';
     document.getElementById('invoiceDueDate').value =cyberdesk.transaction_date;
     document.getElementById('trasactionTime34').value = '';
	   document.getElementById('trasactionTime34').value = cyberdesk.transaction_time;
      $("#payment-btns01").empty(); 
      $("#payment-btns01").hide();
      
      // print the documet
      setTimeout(function(){ 
     // window.print(); 
      }, 100);
      // print the documet

      setTimeout(function(){ 
      $("#topInvoiceNavContents").show();
      }, 700);


	} else if(cyberdesk.transaction_status == 'failed'){
                    
    $("#topInvoiceNavContents").hide();
    $("#topResponse98").empty();
    $("#topResponse98").append('Payment failed!');  
    $("#payment-btns01").hide();
    $("#paymentresponseDivBottom").empty();
    $("#paymentresponseDivBottom").show();
    $("#paymentresponseDivBottom").append('<center><a href="" style="width:100%;height:30px;">Failed please try again!</a></center>');
   
    }
 
							
	});
						  
						}); 
			 
					}else{
						
						
					}
				 

             }, 6000);
     //console.log(newdata.transactionReference);
		 
				  
		}); 	
		
		 
		}
		else
		{
		
		    //location.reload();
         alert('Please enter phone number and nrc!');
		}
		
		
	});
  //MOMO TRASACTIO


  
// CASH TRASACTION PAYMENT
$(document).on('click', '.cashTransact01', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  var amount = $('.total-cart').html();
  var userid = $("#invoicedClientId0").html();
  var fname = $("#invoicedClientName0").val();
  var lname =  $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone =  $("#invoicedClientPhone0").val();
  var invoiceNumber= $("#invoiceNumber").html();
  var invoiceDueDate= $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
 if(phone != '' && cartlistDetails != '' && nrc !='')
 {
    datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
   
 $.ajax({    
     data:datastring,
 url: "xd-modules/cashier-module/backend/cashTransact.php",
     type: "POST"	
   
 }).done (function(data) {
  var response = JSON.parse(data);

  if(response.status=='created'){
  
   $("#topInvoiceNavContents").hide();
   $('#invoiceType').empty();
   $('#invoiceType').append('<option value="RECEIPT">RECEIPT</option>');
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(response.receiptnumber);
  document.getElementById('invoiceDueDate').value ='';
  document.getElementById('invoiceDueDate').value =response.date;
  document.getElementById('trasactionTime34').value = '';
  document.getElementById('trasactionTime34').value = response.time;
   $("#payment-btns01").empty(); 
   $("#payment-btns01").hide();
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   setTimeout(function(){ 
   window.print(); 
   }, 100);
   
   setTimeout(function(){ 
   $("#topInvoiceNavContents").show();
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
   }, 700);

  // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
 // $('#paymentresponseDivTop').fadeOut();


  }else{
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');

  }

   //console.log(newdata.transactionReference);

     
}); 	


}
else
{

   //location.reload();
    alert('Please enter phone number and nrc!');
}


}); 


// CASH REPRIT CHARGE
$(document).on('click', '#cashReprintTransact0', function(event){
  event.preventDefault();
  event.stopPropagation();
  alert('reprit me');
  var amount = $(this).data('price');
  var userid = $("#invoicedClientId0").html();
  var fname = $("#invoicedClientName0").val();
  var lname =  $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $(this).data('id');
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = $("#invoiceType").val();
  var phone =  $("#invoicedClientPhone0").val();
  var invoiceDueDate= $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();   
  var cartlist = shoppingCart.listCart();
  var cartlistDetails = JSON.stringify(cartlist);
  
  var invoiceNumber = (Math.floor(100000 + Math.random() * 900000));
  
 if(phone != '' && cartlistDetails != '' && nrc !='')
 {
    datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
   
 $.ajax({    
     data:datastring,
 url: "xd-modules/cashier-module/backend/cashReprintTransact.php",
     type: "POST"	
   
 }).done (function(data) {
  var response = JSON.parse(data);

  if(response.status=='created'){
    
   $("#topInvoiceNavContents").hide();
 // document.getElementById('invoiceDueDate').value ='';
  //document.getElementById('invoiceDueDate').value =response.date;
 // document.getElementById('trasactionTime34').value = '';
 // document.getElementById('trasactionTime34').value = response.time;
   $("#payment-btns01").empty(); 
   $("#payment-btns01").hide();
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   setTimeout(function(){ 
   window.print(); 
   }, 100);
   setTimeout(function(){ 
   $("#topInvoiceNavContents").show();
   }, 700);

  // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
 // $('#paymentresponseDivTop').fadeOut();


  }else{
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Click to close</span></center>');

  }

   //console.log(newdata.transactionReference);

     
}); 	


}
else
{

   //location.reload();
    alert('Please enter phone number and nrc!');
}


}); 
//bankTransact0
$(document).on('click', '.bankTransact0', function(event){
	event.preventDefault();
		event.stopPropagation();
    //alert('Bank');
		 var amount = $('.total-cart').html();
		 var userid = $("#invoicedClientId0").html();
     var fname = $("#invoicedClientName0").val();
		 var lname =  $("#invoicedClientName1").html();
		 var email = $("#invoicedClientEmail0").val();
      var deliveryaddress = $("#invoicedClientAddress0").val();
      var productid = $("#productid").html();
      var pacra = $("#pacra00").html(); 
      var tpin = $("#tpin00").html(); 
      var businessCategory = $("#businesscategory00").html();
      var plotnumber = $("#plotnumber07").val(); 
      var area = $("#area07").val(); 
      var nrc = $("#nrc07").val();
     var transtype = $("#invoiceType").val();
		  var phone =  $("#invoicedClientPhone0").val();
     // var invoiceNumber= $("#invoiceNumber").html();
      var invoiceDueDate= $("#invoiceDueDate").val();
      var deliverylat = $('#lat0').val();
      var deliverylng = $('#lng0').val();
      var bankDepositSlipId = $('#bankDepositSlipId').val();
      var bankAccountName = $('#bankName').val();
      var bankName = $('#bankName').val();
      var cartlist = shoppingCart.listCart();
		  var cartlistDetails = JSON.stringify(cartlist);
     //alert(bankAccountName);
    
		if(phone != '' && cartlistDetails != '' && nrc !='' && bankDepositSlipId != '' && bankAccountName != '' && bankName != '')
		{
		   datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceDueDate='+invoiceDueDate+'&bankDepositSlipId='+bankDepositSlipId+'&bankAccountName='+bankAccountName+'&bankName='+bankName+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
		  
    $.ajax({
                 
        data:datastring,
        url: "xd-modules/cashier-module/backend/bankTransact.php",
        type: "POST"	
      
    }).done (function(data) {
     var response = JSON.parse(data);

     if(response.status=='created'){ 
      $("#topInvoiceNavContents").hide();
      $('#invoiceType').empty();
      $('#invoiceType').append('<option value="RECEIPT">RECEIPT</option>');
      $('#invoiceNumber').empty();
      $('#invoiceNumber').append(response.receiptnumber);
     document.getElementById('invoiceDueDate').value ='';
     document.getElementById('invoiceDueDate').value =response.date;
     document.getElementById('trasactionTime34').value = '';
	   document.getElementById('trasactionTime34').value = response.time;
      $("#payment-btns01").empty(); 
      $("#payment-btns01").hide();
      $("#paymentresponseDivBottom").empty();
      $("#paymentresponseDivBottom").show();
     // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
    // $('#paymentresponseDivTop').fadeOut();
     
     setTimeout(function(){ 
      window.print(); 
    }, 100);
    setTimeout(function(){ 
      $("#topInvoiceNavContents").show();
      $('#printReceiptDiv102').empty();
      $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
     
    }, 700);

      //$('#payment-btns-div01').append('<form id="depositslipform" method="post" enctype="multipart/form-data"></form>');
      //$('#depositslipform').append('<div class="w3-col l12 m12 s12" style="color:white;"><p>Capture or upload bank deposit slip</p><span id="capture-camera"><span class="fontx fx-camera" style="background-color:white;color:rgba(96, 146, 205,1);padding:12px;border-radius:50%;height:100px;width:100%;font-size:3.5em"></span></span> <p>Or</p><p> <input type="file" name="file" accept="image/*" id="imageInput" style="border-radius:6px;height:38px;"/><input type="text" name="invoiceNumber01" value="'+invoiceNumber01+'" style="display:none;"/></p>');
      //$('#depositslipform').append('<center><input type="submit" name="action" id="bankTransact03" class="w3-btn" value="Later" style="background-color:rgba(96, 146, 205,1);border-radius:6px;height:38px;width:80px;cursor:pointer;color:white;outline:none;border:1px solid white;margin-top:15px;font-family:segoe ui light;margin-right:15px"/> <input type="submit" name="action" id="bankTransact02" class="w3-btn" value="Upload" style="background-color:white;border-radius:6px;height:38px;width:80px;cursor:pointer;color:rgba(96, 146, 205,1);outline:none;border: none;margin-top:15px;font-family:segoe ui light"/></center><p style=""color:rgba(96, 146, 205,1);>&copy; MMC</p>');
    
     }else{
      $("#paymentresponseDivBottom").empty();
      $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Okay</span></center>');
 
     }

      //console.log(newdata.transactionReference);
   
        
  }); 	
  
   
  }
  else
  {
  
      //location.reload();
       alert('Please enter phone number and nrc!');
  }
  
  
});
//bankTransact02
$(document).on('submit', '#depositslipform', function(event){
  event.preventDefault();
  event.stopPropagation();
   var invoiceNumber01 = $('#invoiceNumber01').val();
   
  var extension = $('#imageInput').val().split('.').pop().toLowerCase();
   
  if(extension != ''){
      if(jQuery.inArray(extension, ['gif','png','jpg','jpeg']) == -1)
      {
          alert("Invalid Image File");
          $('#imageInput').val('');
          return false;
      }
  }	
    
  
  if(extension != '')
  {
   $('#payment-btns-div01').empty();
   $('#payment-btns-div01').append('<center><p>Uploading...</p></center>');
        
      $.ajax({
          url:"xd-modules/payment-processing/uploadDepositSlip.php",
          method:'POST',
          data:new FormData(this),
          contentType:false,
          processData:false,
          catche:false,
          success:function(data)
          {
          
          var postStatus = JSON.parse(data);
             
             
                if(postStatus.status=='uploaded'){
                
              $("#depositslipform").trigger('reset'); //jquery
              $("#topInvoiceNavContents").hide();
              $("#topResponse98").empty();
              $("#topResponse98").append('Payment succesful!');  
              $('#payment-btns-div01').empty();
              $('#payment-btns-div01').append('<a href="" id="closeDepositSlipProcess" class="w3-col l12 m12 s12" style="color:white;"><p style="background-color:white;width:100px;color:rgba(96, 146, 205,1);padding:7px;border-radius:4px;">CLose</p></a>');     
                  
            } else{
              $("#depositslipform").trigger('reset'); //jquery
              
              
             }
                     
              
              
                
          }
      });
  }
  else
  {
  
            // $('#upload_media_form0946').hide();
             $('#status44').empty();
             $('#status44').append('Please enter phone number and nrc!');
                
  }
});
/// opting out of uploadig deposit slip
$(document).on('click', '#bankTransact03', function(event){
 // alert('you can upload or capture deposit slip later ');
  shoppingCart.clearCart();
  displayCart();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
  setTimeout(function(){
   // location.reload();
	}, 500);
});
/// opting out of uploadig deposit slip

//closeDepositSlipProcess
$(document).on('click','#closeDepositSlipProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
  $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
//  $("#payment-btns-div0").hide();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  //clear-cart
  shoppingCart.clearCart();
  displayCart();
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 //$('#invoiceNumber').empty();
 //$('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});


//GET INVOICES DETAILS
$(document).on('click','#invoiceDetails0',function (event) {
	event.preventDefault(); 
	event.stopPropagation();  
	var id = $(this).data('id'); 
	var names = $(this).data('names');
	var address = $(this).data('address');
	 var email = $(this).data('email'); 
	 var phone = $(this).data('phone');
	 var due = $(this).data('due');
	 var amount = $(this).data('amount');
	//alert(id);alert(names);alert(email);

   $('#external_page_contents').empty(); 
    $('#external_page_contents').load('xd-modules/admin-modules/create_invoice.html',function() {
    $('#create_invoice_modal').fadeIn('slow');
	$('#addInvoicedItem0').hide();
	$('#addInvoicedItem0').hide();
	$('#invoicedClientId0').empty();
	$('#invoicedClientId0').append(id);
	$('#invoicedClientName0').empty();
	$('#invoicedClientName0').append(names);
	$('#invoicedClientAddress0').empty();
	$('#invoicedClientAddress0').append(address);
	$('#invoicedClientEmail0').empty();
	$('#invoicedClientEmail0').append(email);
	$('#invoicedClientPhone0').empty();
	$('#invoicedClientPhone0').append(phone);
	$('#invoicedClientId0').empty();
	$('#invoicedClientId0').append(id);
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(amount);
	$('#invoiceDueDate').val('');
	$('#invoiceDueDate').val(due);
	
	datastring='id='+id;
			   
	 $.ajax({
										 
		 data:datastring,
		 url: "xd-modules/accounts-module/backend/edit-product-service.php",
		 type: "POST"
	 
 
	 }).done (function(data) {
	 
	 
			 
	 }); 

   });
  

});
 

//addInvoiceItem0
$(document).on('click','#addInvoiceClient0',function (event) {
	addInvoiceClient();
  });
  function addInvoiceClient() {
	   
   $('#invoiceAddClients').fadeIn('slow');
	$('.invoice_modal_contents345').fadeOut('slow');
  $('#backToInvoice0').remove();
	$('#invoiceAddClientsTopnav').empty();
	$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l10 m10 s10" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchUsersForReceiptInvoice" type="text" placeholder="Search clients..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0,0,0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l1 m1 s1" style="padding-top: 5px;"><span class="fontx fx-more-vertical" style="color:rgba(96, 146, 205,1);font-size:1.3em;"></span></div></div>');
	//$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top" style="background-color:rgba(96, 146, 205,1);height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:#fff;font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:#eee;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsForReceiptInvoice" type="text" placeholder="Search..." style="font-weight:400;outline:none;color:#eee;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:#eee;font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 5px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:#eee;padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:25px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.7em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a</div>');
	
  $('#invoiceAddClientsDiv08').empty(); 
   $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
   
   
		$.getJSON('xd-modules/cashier-module/backend/allClients.php',function(data){

			$('#invoiceAddClientsDiv08').empty();
			$('#invoiceAddClientsDiv08').append('<br/>');
			$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
			$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
		$.each(data.freelancedetails, function(i,freelance) {
		  if(freelance.status=='active'){

			 $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" id="addInvoiceClient01" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
			 
		   }else{
		 //	there are no active clients or something 


		   }
		});

       //$('#invoiceAddClients').append('<div id="backToInvoice0" class="fontx fx-arrow-right" style="position:fixed;height:40px;width:40px;border-radius:50%;color:#fff;background-color: rgba(96, 146, 205,1);line-height:40px;right:10%;bottom:8%;cursor: pointer;"></div></div>');
		
	});

};

// SEARCH USERS SCRIPT
//searchUsers.php
$(document).on('change keyup','.searchUsersForReceiptInvoice',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchUsersForReceiptInvoice").val()=='') {	
	addInvoiceClient()
  } else{
   //var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $(".searchUsersForReceiptInvoice").val(); 
	 datastring='searchKey='+searchKey;
	 $('#invoiceAddClientsDiv08').empty(); 
	 $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
	 	 
	 $.ajax({
				  
		   data:datastring,
	   url: "xd-modules/cashier-module/backend/searchUsers.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
	  $('#invoiceAddClientsDiv08').empty(); 
	  $('#invoiceAddClientsDiv08').append('<br/>');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
  
	$.each(details0.details, function(i,freelance) {
	//	$('#invoiceAddClientsDiv08').append('<div id="'+freelance.id+'" class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;border-bottom:1px solid #eee;"><div class="w3-col l11 m11 s9"><span class="w3-col l3 m3 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' ('+freelance.business_category+')</span> <span class="w3-col l12 m12 s12" style="color:gray;">'+freelance.names+' ('+freelance.nrc+')</span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l12 m12 s12"><b>PACRA:</b> <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l12 m12 s12"><b>TPIN:</b> <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span><span class="w3-col l2 m2 s12" style="padding-left:7px;"><span class="w3-col l12 m12 s12"> '+freelance.email+'</span><span class="w3-col l12 m12 s12"> '+freelance.phone+'</span></span><span class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="padding-left:10px;"> '+freelance.address+'</span><span class="w3-col l12 m12 s12" style="padding-left:10px;"> '+freelance.plot_number+' '+freelance.area+'</span></span><span id="addInvoiceClient01" class="w3-col l1 m1 s12" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'"><a href="#" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:17px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;line-height:20px;">Add</a></span></div></div>');
  $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" id="addInvoiceClient01" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
			 	   
	  });
	 
	}); 	
	
	

  } 
  
		  
});
//backToInvoiceItem0
$(document).on('click','#backToInvoice0',function (event) { 
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');

});
//close_create_invoice_modal
$(document).on('click','#close_create_invoice_modal',function (event) { 
	$('#create_invoice_modal').fadeOut('slow');
	 
});
$(document).on('click','.close_invoiceAddClients_div',function (event) {
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');		  
});
//addInvoiceClient01
$(document).on('click','#addInvoiceClient01',function (event) { 
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');
	var id = $(this).data('id'); 
	var names = $(this).data('names');
	var companyname = $(this).data('orgname');
	var address = $(this).data('address');
	 var email = $(this).data('email'); 
	 var phone = $(this).data('phone'); 
	 var pacra =$(this).data('pacra');
	 var tpin =$(this).data('tpin');
	 var nrc = $(this).data('nrc'); 
	 var area =$(this).data('pacra');
	 var plotnumber =$(this).data('plotnumber');
	 var businessCategory=$(this).data('businesscategory');
	 //var plotnumber =$(this).data('tpin');
	 $('#invoicedClientId0').empty();
	 $('#invoicedClientId0').append(id);
	 document.getElementById('invoicedClientName0').vallue='';
	 document.getElementById('invoicedClientName0').value=companyname;
	 $('#invoicedClientName1').empty();
	 $('#invoicedClientName1').append(names);
   document.getElementById('invoicedClientAddress0').value='';
	 document.getElementById('invoicedClientAddress0').value=address;
	 document.getElementById('plotnumber07').value='';
	 document.getElementById('plotnumber07').value= plotnumber;
	 document.getElementById('area07').value='';
	 document.getElementById('area07').value=area;
   document.getElementById('nrc07').vallue='';
	 document.getElementById('nrc07').vallue=nrc;
	 document.getElementById('invoicedClientEmail0').value='';
	 document.getElementById('invoicedClientEmail0').value=email;
	  $('#invoicedClientId0').empty();
	 $('#invoicedClientId0').append(id);
	 $('#pacra00').empty();
	 $('#pacra00').append(pacra); 
	 $('#tpin00').empty();
	 $('#tpin00').append(tpin); 
	 $('#businesscategory00').empty();
	 $('#businesscategory00').append(businessCategory);
	document.getElementById('invoicedClientPhone0').value ='';
	document.getElementById('invoicedClientPhone0').value = phone;
		
});

//addInvoicedItem0
$(document).on('click','#addInvoicedItem0',function (event) {
	addInvoicedItem();
  });
  function addInvoicedItem() {	  
	$('#invoiceAddClients').fadeIn('slow'); 
 // var div34 = document.getElementById('transact_modal');
  document.getElementById('transact_modal').scroll({top:0,behavior:'smooth'});
 // div34.scrollTop = 0;
	$('.invoice_modal_contents345').fadeOut('slow');
	$('#invoiceAddClientsTopnav').empty();
	$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsForReceiptInvoice" type="text" placeholder="Search & add items to cart..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0, 0, 0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 0px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:rgba(96, 146, 205,1);padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:22px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.4em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a</div>');
	
  $('#invoiceAddClientsDiv08').empty(); 
   $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
   
   
   $.getJSON('xd-modules/cashier-module/backend/allProducts.php',function(data){
	$('#invoiceAddClientsDiv08').empty(); 
	$('#invoiceAddClientsDiv08').append('<br/>');
	$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');

 //$('#invoiceAddClientsDiv08').append('<center style="margin-top:17%;"><p>Unfortunately no products/services were added to your account. Contact your superiors!</p></center>');
     $.each(data.freelancedetails, function(i,freelance) {

      $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l4 m6 s12" style="padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" data-chargerate="'+freelance.charge_rate+'" data-duedate="'+freelance.due_date+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
 
   });
 


	$('#invoiceAddClients').append('<div id="backToInvoice0" class="w3-bottom" style="position:fixed;height:40px;width:100%;color:#fff;background-color:rgba(96, 146, 205,1);line-height:40px;cursor: pointer;font-weight:600;">PROCEED <span class="fontx fx-arrow-right"></span></div></div>');
		

	});

};
// search products or chart of A/C
$(document).on('change keyup','.searchProductsForReceiptInvoice',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchProductsForReceiptInvoice").val()=='') {	
	addInvoicedItem();
  } else{
   //var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $(".searchProductsForReceiptInvoice").val(); 
	 datastring='searchKey='+searchKey;
	 $('#invoiceAddClientsDiv08').empty(); 
	 $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
	 	 
	 $.ajax({
				  
		   data:datastring,
	     url: "xd-modules/cashier-module/backend/searchProducts.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
	  $('#invoiceAddClientsDiv08').empty(); 
	  $('#invoiceAddClientsDiv08').append('<br/>');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
  
	$.each(details0.details, function(i,freelance) {

  //  $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" style="padding-left:7px;margin-top:3px;background-color:rgba(250,250,250);"><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">ID:</b>'+freelance.id+'</div><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Charge:</b>  '+freelance.price+'</div><div class="w3-col l2 m2 s12"><b style="color:black;">'+freelance.name+'</b></div><div class="w3-col l4 m4 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Desc:</b> '+freelance.description+'</a></div><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Status:</b> '+freelance.status+'</a></div><div class="w3-col l2 m2 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Timestamp:</b> '+freelance.datemodified+'</a></div><div class="w3-col l1 m1 s12"><span class="w3-hide-large w3-hide-medium" style="float:left;">K'+freelance.price+'</span><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-description="'+freelance.description+'"  data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'"  data-chargerate="'+freelance.charge_rate+'" data-duedate="'+freelance.due_date+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;line-height:20px;cursor:pointer;"/></div></div>');
    $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l4 m6 s12" style="padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" data-chargerate="'+freelance.charge_rate+'" data-duedate="'+freelance.due_date+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
 
	  });
	 
	}); 	
	
	

  } 
  
		  
});
// end of search products or chart of A/C




 //sum invoice
 $(document).on('click','#backToInvoice0',function (event) {

	var total = 0;
	$('.invoiceItemTotalPrice0').each(function(){
		total += parseFloat($(this).text().replace(/,/g,''))
	});
	//$('.total').text(total)
	//alert(total);
	$('#invoiceSubTotal').empty();
	$('#invoiceSubTotal').append(total);
	//invoiceTaxTotal0
	var taxPercent = total*0.10;
	$('#invoiceTaxTotal0').empty();
	$('#invoiceTaxTotal0').append(taxPercent);
    //invoiceTotal0
	var invoiceTotal = total-taxPercent;
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(invoiceTotal);
 
});

//CHANGING INVOICE UNITS AND SUMING UP THE TOTAL INVOICE

$(document).on('click','.invoiceItemDiv0',function (event) {

	var count = $(this).closest(".invoiceItemDiv0").find(".invoiceUnits0").val();
	var unitPrice = $(this).closest(".invoiceItemDiv0").find(".invoiceItemPrice0").html();
	var totalItemPrice = unitPrice*count;
	//alert(count);alert(totalItemPrice);
	$(this).closest(".invoiceItemDiv0").find(".invoiceItemTotalPrice0").empty();
	$(this).closest(".invoiceItemDiv0").find(".invoiceItemTotalPrice0").append(totalItemPrice);
	
	// NOW WE TOTAL UP THE INVOICE TOTAL PRICE FOR EACH ITEM
	var total = 0;
	$('.invoiceItemTotalPrice0').each(function(){
		total += parseFloat($(this).text().replace(/,/g,''))
	});
	//$('.total').text(total)
	//alert(total);
	$('#invoiceSubTotal').empty();
	$('#invoiceSubTotal').append(total);
	//invoiceTaxTotal0
	var taxPercent = total*0.10;
	$('#invoiceTaxTotal0').empty();
	$('#invoiceTaxTotal0').append(taxPercent);
	//invoiceTotal0
	var invoiceTotal = total-taxPercent;
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(invoiceTotal);
	
	});
	
//CHANGING INVOICE UNITS AND SUMING UP THE TOTAL INVOICE
 