<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

// Include database configuration
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    // Connect to the database
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Query to retrieve product details and their totals
    $getproductsquery = "SELECT 
                            cfname,
                            clname,
                            cphone, 
                            user_id,
                            COUNT(product_id) AS accounts,
                            SUM(transaction_amount) AS producttotal,
                            SUM(quantity) AS totalquantity
                        FROM 
                            transaction_details 
                        WHERE 
                            debit_or_credit='Credit' 
                            AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') 
                        GROUP BY 
                        user_id";

    // Execute the query
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    // Initialize variables
    $nestedData = array(); 
    $totalProductTotal = 0;
    $totalAccounts = 0;
	$totalQuantityTotal = 0;
    // Fetch individual records and calculate total sum
    while ($row = $getproducts->fetch()) {
        // Add the producttotal to the total sum
        $totalProductTotal += $row['producttotal'];
		$totalAccounts += $row['accounts'];
		$totalQuantityTotal += $row['totalquantity'];
        // Add the current row to the nested data array
        $nestedData[] = $row;
    }

    // Prepare the response data
    $totalrecords = count($nestedData);
    $json_data = array(
        "details" => $nestedData,   // total data array
        "totalProductTotal" => $totalProductTotal,
		"totalAccounts" => $totalAccounts,
		"totalQuantityTotal" => $totalQuantityTotal,
        "numofrows" => $totalrecords 
    );

    // Send data as JSON format
    echo json_encode($json_data);
    exit;
} catch(PDOException $e) {
    // Handle database connection errors
    $error_message = "Connection failed: " . $e->getMessage();
    echo json_encode(array("error" => $error_message));
    exit;
}
?>
