<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"]; 
    $orgid = $_SESSION["orgid"];

  //  $startDateInput = filter_input(INPUT_POST, "startDate");
   // $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $filterKey = filter_input(INPUT_POST, "filterKey");

    // Initialize conditions and parameters
    $conditions = ["1=1"];
    $parameters = [];

    // Handle date input safely and ignore if empty
    /*
    if (!empty($startDateInput)) {
        $startDate = date_create_from_format('Y-m-d', $startDateInput);
        if ($startDate) {
            $startDateFormatted = $startDate->format('Y-m-d');
        }
    }

    if (!empty($endDateInput)) {
        $endDate = date_create_from_format('Y-m-d', $endDateInput);
        if ($endDate) {
            $endDateFormatted = $endDate->format('Y-m-d');
        }
    }

    // Add date condition only if both dates are valid
    if (isset($startDateFormatted) && isset($endDateFormatted)) {
        $conditions[] = "(signup BETWEEN :start_date AND :end_date)";
        $parameters[':start_date'] = $startDateFormatted;
        $parameters[':end_date'] = $endDateFormatted; 
    }
    */
    if (!empty($searchKey)) {
        $conditions[] = "(names LIKE :search_key OR phone LIKE :search_key OR email LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    if (!empty($filterKey) && $filterKey != 'All') {
        $conditions[] = "(status = :filter_key)";
        $parameters[':filter_key'] = $filterKey;
    }

    // Ensure orgid is included
    $conditions[] = "role <> 'client' AND org_id = :orgid";
    $parameters[':orgid'] = $orgid;

    // Query construction
    $getDriversQuery = "
        SELECT id, email, names, phone, avatar, role, status, signup, lastlogin
        FROM users
        WHERE " . implode(" AND ", $conditions) . "
        ORDER BY names DESC";

    $getDrivers = $conn->prepare($getDriversQuery);

    // Bind parameters
    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    $getDrivers->execute();

    // Fetch results
    $jobdetails = $getDrivers->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(["details" => $jobdetails, 'numofrows' => count($jobdetails)]);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
