<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');  // Set the response type to JSON

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Connect to the database
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    // Set the PDO error mode to exception
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get user logged ID
    $userloggedid = $_SESSION["userid"];
    
    // Retrieve and sanitize input
    $departmentId = intval($_POST["departmentId"] ?? 0); // Ensure it's an integer
    $departmentName = htmlspecialchars($_POST["departmentName"] ?? '', ENT_QUOTES, 'UTF-8');
    $departmentCode = htmlspecialchars($_POST["departmentCode"] ?? '', ENT_QUOTES, 'UTF-8');
    $departmentDescription = htmlspecialchars($_POST["departmentDescription"] ?? '', ENT_QUOTES, 'UTF-8');
    $departmentStatus = htmlspecialchars($_POST["departmentStatus"] ?? '', ENT_QUOTES, 'UTF-8');

    // Check if required fields are provided
    if ($departmentId === 0 || empty($departmentName) || empty($departmentCode)) {
        echo json_encode(['status' => 'Error', 'message' => 'Missing required fields']);
        exit;
    }

    // Prepare the SQL update query using prepared statements
    $query = "UPDATE departments 
              SET department_code = :departmentCode,
                  name = :departmentName,
                  description = :departmentDescription,
                  status = :departmentStatus
              WHERE id = :departmentId";
    
    // Prepare the statement
    $stmt = $conn->prepare($query);
    
    // Bind parameters to prevent SQL injection
    $stmt->bindParam(':departmentId', $departmentId, PDO::PARAM_INT);
    $stmt->bindParam(':departmentName', $departmentName, PDO::PARAM_STR);
    $stmt->bindParam(':departmentCode', $departmentCode, PDO::PARAM_STR);
    $stmt->bindParam(':departmentDescription', $departmentDescription, PDO::PARAM_STR);
    $stmt->bindParam(':departmentStatus', $departmentStatus, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Check if any rows were updated
    if ($stmt->rowCount() > 0) {
        // Success response
        $json_data = array('status' => 'Department updated successfully');
        echo json_encode($json_data);  // Only JSON response
    } else {
        // No rows updated (either no change or department not found)
        $json_data = array('status' => 'No changes made or department not found');
        echo json_encode($json_data);  // Only JSON response
    }
} catch (Exception $e) {
    // Handle exceptions (e.g., database connection error, query failure)
    $json_data = array('status' => 'Error', 'message' => $e->getMessage());
    echo json_encode($json_data);  // Only JSON response
}
?>
