<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');  // Set the response type to JSON

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Connect to the database
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    // Set the PDO error mode to exception
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get user logged ID
    $userloggedid = $_SESSION["userid"];
    
    // Retrieve and sanitize input
    $roleId = intval($_POST["roleId"] ?? 0); // Ensure it's an integer 
    $roleName = htmlspecialchars($_POST["roleName"] ?? '', ENT_QUOTES, 'UTF-8');
    $departmentId = intval($_POST["departmentId"] ?? 0); // Ensure it's an integer
    $department = htmlspecialchars($_POST["department"] ?? '', ENT_QUOTES, 'UTF-8'); 
    $roleDescription = htmlspecialchars($_POST["roleDescription"] ?? '', ENT_QUOTES, 'UTF-8');
    $roleStatus = htmlspecialchars($_POST["roleStatus"] ?? '', ENT_QUOTES, 'UTF-8');
  
    // Prepare the SQL update query using prepared statements
    $query = "UPDATE roles 
              SET 	role_name = :roleName, 
                  description = :roleDescription,
                  role_status = :roleStatus,
                  department_id = :departmentId,
                   department = :department
              WHERE role_id = :roleId";
    
    // Prepare the statement
    $stmt = $conn->prepare($query);
    
    // Bind parameters to prevent SQL injection
    $stmt->bindParam(':roleName', $roleName, PDO::PARAM_STR);
    $stmt->bindParam(':roleId', $roleId, PDO::PARAM_INT);
    $stmt->bindParam(':departmentId', $departmentId, PDO::PARAM_INT);
    $stmt->bindParam(':department', $department, PDO::PARAM_STR);
    $stmt->bindParam(':roleDescription', $roleDescription, PDO::PARAM_STR);
    $stmt->bindParam(':roleStatus', $roleStatus, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Check if any rows were updated
    if ($stmt->rowCount() > 0) {
        // Success response
        $json_data = array('status' => 'Updated successfully');
        echo json_encode($json_data);  // Only JSON response
    } else {
        // No rows updated (either no change or department not found)
        $json_data = array('status' => 'No changes made or not found');
        echo json_encode($json_data);  // Only JSON response
    }
} catch (Exception $e) {
    // Handle exceptions (e.g., database connection error, query failure)
    $json_data = array('status' => 'Error', 'message' => $e->getMessage());
    echo json_encode($json_data);  // Only JSON response
}
?>
