<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit;
}

$startDateInput = filter_input(INPUT_POST, "startDate");
$endDateInput = filter_input(INPUT_POST, "endDate");
$searchKey = filter_input(INPUT_POST, "searchKey");
$selectedClient = filter_input(INPUT_POST, "selectedClient");
$status = filter_input(INPUT_POST, "status");

if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
    echo json_encode(["error" => "At least one input parameter is required"]);
    exit;
}

$conditions = [];
$parameters = [];

if (!empty($startDateInput)) {
    $conditions[] = "signup >= :start_date";
    $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
}

if (!empty($endDateInput)) {
    $conditions[] = "signup <= :end_date";
    $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
}

if (!empty($searchKey)) {
    $conditions[] = "(email LIKE :search_key OR names LIKE :search_key OR phone LIKE :search_key OR address LIKE :search_key OR nrc LIKE :search_key OR org_name LIKE :search_key OR company_registration_number LIKE :search_key OR tpin LIKE :search_key OR area LIKE :search_key OR plot_number LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
}

$getproductsquery = "SELECT id, email, names, phone, address, nrc, org_name, company_registration_number, tpin, area, plot_number, business_category, user_type, status, signup
                    FROM users 
                    WHERE role = 'client' 
                    AND area='$selectedClient'
                    AND status = '$status'";

if (!empty($conditions)) {
    $getproductsquery .= " AND " . implode(" AND ", $conditions);
}

$getproductsquery .= " ORDER BY names ASC";

try {
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
} catch (PDOException $e) {
    echo "Query execution failed: " . $e->getMessage();
    exit;
}

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$totalrecords = $getproducts->rowCount();

$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row;
}

$json_data = [
    "freelancedetails" => $nestedData,
    'numofrows' => $totalrecords
];

echo json_encode($json_data);
exit;