<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

// Ensure all necessary parameters are passed in the POST request
if (empty($_POST['email']) || empty($_POST['phone']) || empty($_POST['name']) || empty($_POST['userrole']) || empty($_POST['roleid']) || empty($_POST['department']) || empty($_POST['departmentid'])) {
    echo json_encode(['status' => 'missingdata']);
    exit;
}

// Get POST data
$email = filter_input(INPUT_POST, "email");
$phone = filter_input(INPUT_POST, "phone");
$user_name = filter_input(INPUT_POST, "name");
$userrole = filter_input(INPUT_POST, "userrole");
$roleid = filter_input(INPUT_POST, "roleid");
$department = filter_input(INPUT_POST, "department");
$departmentid = filter_input(INPUT_POST, "departmentid");

// Database connection
require_once '../../../xd-assets/backend/config/dbconfig.php';
$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Check if email exists
$emailCheckQuery = "SELECT COUNT(*) FROM users WHERE email = :email";
$emailCheckStmt = $conn->prepare($emailCheckQuery);
$emailCheckStmt->bindParam(':email', $email);
$emailCheckStmt->execute();
$emailExists = $emailCheckStmt->fetchColumn();

if ($emailExists > 0) {
    echo json_encode(['status' => 'The email already exists']);
    exit;
}

// Handle file upload (if any)
$imagePath = '';  // Default to empty string if no file uploaded
if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
    $fileError = $_FILES['file']['error'];
    if ($fileError === UPLOAD_ERR_OK) {
        $sourcePath = $_FILES['file']['tmp_name'];
        $extension = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
        $new_name = rand() . '.' . $extension;
        $targetPath = "../../../xd-uploads/user-pictures/" . $new_name;

        if (move_uploaded_file($sourcePath, $targetPath)) {
            $imagePath = "xd-uploads/user-pictures/" . $new_name;
        } else {
            echo json_encode(['status' => 'notuploaded', 'error' => 'Failed to move uploaded file']);
            exit;
        }
    } else {
        echo json_encode(['status' => 'notuploaded', 'file_error' => $fileError]);
        exit;
    }
}
 // Generate a random password (12 characters)
$randomPassword = bin2hex(random_bytes(6)); // 6 bytes = 12 characters
// Hash the password using password_hash()
$user_password = password_hash($randomPassword, PASSWORD_DEFAULT);

$status = 'active';
$org_name = $_SESSION["orgname"];
$org_id = $_SESSION["orgid"];

// Prepare SQL query
$postingquery = "
    INSERT INTO users (email, names, phone, password, avatar, role, role_id, department, department_id, org_name, org_id, status, signup, user_id, user_name)
    VALUES (:email, :user_name, :phone, :user_password, :imagePath, :userrole, :roleid, :department, :departmentid, :org_name, :org_id, :status, NOW(), :org_id, :org_name)
";


// Prepare and bind parameters
$insertposting = $conn->prepare($postingquery);
$insertposting->bindParam(':email', $email);
$insertposting->bindParam(':user_name', $user_name);
$insertposting->bindParam(':phone', $phone);
$insertposting->bindParam(':user_password', $user_password);
$insertposting->bindParam(':imagePath', $imagePath); // Ensure imagePath is bound correctly
$insertposting->bindParam(':userrole', $userrole);
$insertposting->bindParam(':roleid', $roleid);
$insertposting->bindParam(':department', $department);
$insertposting->bindParam(':departmentid', $departmentid);
$insertposting->bindParam(':org_name', $org_name);
$insertposting->bindParam(':org_id', $org_id);
$insertposting->bindParam(':status', $status); 
// Execute the query and check if successful
try {
    if ($insertposting->execute()) {
        echo json_encode(['status' => 'Created']);
    } else {
        echo json_encode(['status' => 'notposted']);
        if ($imagePath) {
            unlink($targetPath); // Delete uploaded file if insert fails
        }
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
