<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Establish PDO connection
$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); 

// Retrieve session and input parameters
$agentname = $_SESSION["username"];
$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];

$depotName = filter_input(INPUT_POST, "depotName");
$depotCode = filter_input(INPUT_POST, "depotCode"); 
$description = filter_input(INPUT_POST, "description");
$address = filter_input(INPUT_POST, "depotaddress");
$email = filter_input(INPUT_POST, "email");
$category = filter_input(INPUT_POST, "category");
$pobox = filter_input(INPUT_POST, "pobox"); 
$contact = filter_input(INPUT_POST, "contact");
$lat = filter_input(INPUT_POST, "lat"); 
$lng = filter_input(INPUT_POST, "lng");
$depotType = filter_input(INPUT_POST, "depotType");
$status = 'Active';  // Static 'Active' value

// Corrected INSERT SQL query
$insertnewuserQuery = "INSERT INTO depots (depot_name, depot_code, depot_description, depot_type, depot_address, depot_po_box, depot_email, depot_cotacts, lat, lng, status, depot_category, sessionUserId, org_name, org_id) 
                       VALUES (:depotName, :depotCode, :description, :depotType, :address, :pobox, :email, :contact, :lat, :lng, :status, :category, :userloggedid, :orgname, :orgid)";

$insertnewUser = $conn->prepare($insertnewuserQuery);

// Bind parameters to the prepared statement
$insertnewUser->bindParam(':depotName', $depotName);
$insertnewUser->bindParam(':depotCode', $depotCode);
$insertnewUser->bindParam(':description', $description);
$insertnewUser->bindParam(':depotType', $depotType);
$insertnewUser->bindParam(':address', $address);
$insertnewUser->bindParam(':pobox', $pobox);
$insertnewUser->bindParam(':email', $email);
$insertnewUser->bindParam(':contact', $contact);
$insertnewUser->bindParam(':lat', $lat);
$insertnewUser->bindParam(':lng', $lng);
$insertnewUser->bindParam(':status', $status);  // Set static 'Active' value
$insertnewUser->bindParam(':category', $category);
$insertnewUser->bindParam(':userloggedid', $userloggedid);
$insertnewUser->bindParam(':orgname', $orgname);
$insertnewUser->bindParam(':orgid', $orgid);

// Execute the prepared statement
$insertnewUser->execute();

// Check if the insertion was successful
if ($insertnewUser->rowCount() > 0) {
    $json_data = array(
        'status' => 'Created'
    );
} else {
    $json_data = array(
        'status' => 'not created'
    );
}

// Return JSON response
echo json_encode($json_data);
exit;

?>
