<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Establish PDO connection
$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); 

// Retrieve session and input parameters
//$agentname = $_SESSION["username"];
$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];

$departmentName = filter_input(INPUT_POST, "departmentName");
$departmentCode = filter_input(INPUT_POST, "departmentCode"); 
$departmentDescription = filter_input(INPUT_POST, "departmentDescription");
$departmentStatus = filter_input(INPUT_POST, "departmentStatus"); 

// Corrected INSERT SQL query
$insertnewuserQuery = "INSERT INTO departments (department_code,name, description, org_name, org_id, status, sessionUserId) 
                       VALUES (:departmentCode, :departmentName, :departmentDescription, :orgname, :orgid,  :departmentStatus, :userloggedid)";

$insertnewUser = $conn->prepare($insertnewuserQuery);

// Bind parameters to the prepared statement
$insertnewUser->bindParam(':departmentName', $departmentName);
$insertnewUser->bindParam(':departmentCode', $departmentCode);
$insertnewUser->bindParam(':departmentDescription', $departmentDescription); 
$insertnewUser->bindParam(':departmentStatus', $departmentStatus); 
$insertnewUser->bindParam(':orgname', $orgname); 
$insertnewUser->bindParam(':orgid', $orgid); 
$insertnewUser->bindParam(':userloggedid', $userloggedid); 
// Execute the prepared statement
$insertnewUser->execute();

// Check if the insertion was successful
if ($insertnewUser->rowCount() > 0) {
    $json_data = array(
        'status' => 'Created'
    );
} else {
    $json_data = array(
        'status' => 'not created'
    );
}

// Return JSON response
echo json_encode($json_data);
exit;

?>
