<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';
 
$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];

$name = filter_input(INPUT_POST, "name");
$department = filter_input(INPUT_POST, "department"); 
$departmentId = filter_input(INPUT_POST, "departmentId"); 
$description = filter_input(INPUT_POST, "description");
$status = filter_input(INPUT_POST, "status"); 

// Corrected INSERT SQL query
$insertnewuserQuery = "INSERT INTO roles (role_name, description, role_status, department_id, department, org_id, org_name, sessionId) 
                       VALUES (:name, :description, :status, :departmentId, :department, :orgid, :orgname, :userloggedid)";

$insertnewUser = $conn->prepare($insertnewuserQuery);

// Bind parameters to the prepared statement
$insertnewUser->bindParam(':name', $name);
$insertnewUser->bindParam(':department', $department);
$insertnewUser->bindParam(':departmentId', $departmentId); // Corrected placeholder name
$insertnewUser->bindParam(':description', $description); 
$insertnewUser->bindParam(':status', $status); 
$insertnewUser->bindParam(':orgname', $orgname); 
$insertnewUser->bindParam(':orgid', $orgid); 
$insertnewUser->bindParam(':userloggedid', $userloggedid); 

// Execute the prepared statement
$insertnewUser->execute();

// Check if the insertion was successful
if ($insertnewUser->rowCount() > 0) {
    $json_data = array(
        'status' => 'Created'
    );
} else {
    $json_data = array(
        'status' => 'Not Created'
    );
}

// Return JSON response
echo json_encode($json_data);
exit;
?>
