<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit;
}

$startDateInput = filter_input(INPUT_POST, "startDate");
$endDateInput = filter_input(INPUT_POST, "endDate");
$searchKey = filter_input(INPUT_POST, "searchKey");
$selectworkforce = filter_input(INPUT_POST, "selectworkForce");
$status = filter_input(INPUT_POST, "status");

$conditions = [];
$parameters = [];

if (!empty($startDateInput)) {
    $conditions[] = "users.signup >= :start_date";
    $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
}

if (!empty($endDateInput)) {
    $conditions[] = "users.signup <= :end_date";
    $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
}

if (!empty($searchKey)) {
    $conditions[] = "(users.email LIKE :search_key OR users.names LIKE :search_key OR users.phone LIKE :search_key OR users.nrc LIKE :search_key OR users.tpin LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
}

// Fixed query - added DISTINCT to prevent duplicate rows
$getproductsquery = "SELECT DISTINCT 
                        workforce.role_id,
                        roles.role_name,
                        workforce.status, 
                        workforce.department_id,
                        departments.name AS departmentname,
                        workforce.depot_id, 
                        depots.depot_name,
                        users.id, 
                        users.email, 
                        users.names, 
                        users.phone, 
                        users.address, 
                        users.nrc, 
                        users.avatar, 
                        users.company_registration_number, 
                        users.tpin, 
                        users.area, 
                        users.plot_number, 
                        users.user_type
                    FROM workforce
                    INNER JOIN users ON workforce.user_id = users.id
                    INNER JOIN user_roles ON workforce.role_id = user_roles.role_id AND workforce.org_id = user_roles.org_id
                    INNER JOIN depots ON workforce.depot_id = depots.depot_id AND workforce.org_id = depots.org_id
                    INNER JOIN departments ON workforce.department_id = departments.id AND workforce.org_id = departments.org_id
                    INNER JOIN roles ON workforce.role_id = roles.role_id AND workforce.org_id = roles.org_id";


if (!empty($status)) {
    $getproductsquery .= " AND workforce.status = :status";
    $parameters[':status'] = $status;
}

if (!empty($conditions)) {
    $getproductsquery .= " AND " . implode(" AND ", $conditions);
}

$getproductsquery .= " ORDER BY users.names ASC LIMIT 1000";

try {
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
} catch (PDOException $e) {
    echo "Query execution failed: " . $e->getMessage();
    exit;
}

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$totalrecords = $getproducts->rowCount();

$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row;
}

if ($totalrecords === 0) {
    echo json_encode(["error" => "No workforce found"]);
    exit;
}

$json_data = [
    "freelancedetails" => $nestedData,
    'numofrows' => $totalrecords
];

echo json_encode($json_data);
exit;
?>