error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

// Set the PDO error mode to exception
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON data: ' . json_last_error_msg()]);
    exit;
}

foreach ($data as $transaction) {
    $userid = $transaction['userid'] ?? null;
    $phone = $transaction['phone'] ?? null;
    $fname = $transaction['fname'] ?? null;
    $lname = $transaction['lname'] ?? null;
    $email = $transaction['email'] ?? null;
    $deliverylat = $transaction['deliverylat'] ?? null;
    $deliverylng = $transaction['deliverylng'] ?? null;
    $deliveryaddress = $transaction['deliveryaddress'] ?? null;
    $transtype = $transaction['transtype'] ?? null;
    $invoiceNumber = $transaction['invoiceNumber'] ?? null;
    $invoiceDueDate = $transaction['invoiceDueDate'] ?? null;
    $plotnumber = $transaction['plotnumber'] ?? null;
    $area = $transaction['area'] ?? null;
    $nrc = $transaction['nrc'] ?? null;
    $comment = $transaction['comment'] ?? null;
    $payment_mode = $transaction['payment_mode'] ?? null;
    $offline_receipt = $transaction['offline_receipt'] ?? null;

    if (!$userid || !$phone || !$fname || !$lname || !$email || !$deliverylat || !$deliverylng || !$deliveryaddress || !$transtype || !$invoiceNumber || !$invoiceDueDate || !$offline_receipt) {
        continue;
    }

    $checkReceiptQuery = "SELECT id FROM transaction_details WHERE offline_receipt = :offline_receipt";
    $checkReceiptStmt = $conn->prepare($checkReceiptQuery);
    $checkReceiptStmt->bindParam(':offline_receipt', $offline_receipt, PDO::PARAM_STR);
    $checkReceiptStmt->execute();

    if ($checkReceiptStmt->rowCount() > 0) {
        echo json_encode(['status' => 'duplicate', 'message' => 'Offline receipt already exists', 'offline_receipt' => $offline_receipt]);
        exit;
    }

    $getServiceRequestQuery = "SELECT id, receipt_no FROM transaction_details ORDER BY id DESC LIMIT 1";
    $getServiceRequest = $conn->prepare($getServiceRequestQuery);
    $getServiceRequest->execute();
    $lastTransaction = $getServiceRequest->fetch(PDO::FETCH_ASSOC);

    if (!$lastTransaction) {
        echo json_encode(['status' => 'error', 'message' => 'Could not fetch last transaction']);
        exit;
    }

    $last_transaction_id = $lastTransaction['id'];
    $last_transaction_receipt_no = $lastTransaction['receipt_no'];
    $new_receipt_no = ++$last_transaction_receipt_no;

    foreach ($transaction['orderDetails'] as $item) {
        $productname = $item['name'];
        $price = $item['price'];
        $count = $item['count'];
        $total = $item['total'];

        $insertnewuserQuery = "INSERT INTO `transaction_details` 
        (`cfname`, `clname`, `cemail`, `cphone`, `user_id`, `transaction_date`, `transaction_time`, 
        `month`, `week`, `day`, `receipt_no`, `invoiceNumber`, `offline_receipt`, `comment`, 
        `invoiceDueDate`, `payment_mode`, `bank_name`, `bank_account_name`, `business_category`, 
        `pacra`, `tpin`, `org_name`, `org_id`, `lat`, `lng`, `delivery_address`, `area`, `plot_no`, `nrc`, `agent_name`, `agent_id`, `trans_type`, `debit_or_credit`, `order_details`, `product_name`, `product_id`, `product_code`, `product_category`, `product_category_code`, `balance_bf`, `transaction_amount`, `transaction_balance`, `quantity`, `order_code`, `transaction_reference`, `transaction_status`, `depot`, `depot_id`, `depot_code`)
        VALUES 
        (:fname, :lname, :email, :phone, :userid, :transaction_date, :transaction_time, :month, :week, 
        :day, :new_receipt_no, :invoiceNumber, :offline_receipt, :comment, :invoiceDueDate, 
        :payment_mode, :bank_name, :bank_account_name, :business_category, :pacra, :tpin, :org_name, 
        :org_id, :lat, :lng, :delivery_address, :area, :plot_no, :nrc, :agent_name, :agent_id, :trans_type, :debit_or_credit, :order_details, :product_name, :product_id, :product_code, :product_category, :product_category_code, :balance_bf, :transaction_amount, :transaction_balance, :quantity, :order_code, :transaction_reference, :transaction_status, :depot, :depot_id, :depot_code)";

        $insertStmt = $conn->prepare($insertnewuserQuery);

        $insertStmt->bindParam(':fname', $fname);
        $insertStmt->bindParam(':lname', $lname);
        $insertStmt->bindParam(':email', $email);
        $insertStmt->bindParam(':phone', $phone);
        $insertStmt->bindParam(':userid', $userid);
        $insertStmt->bindParam(':transaction_date', $transaction_date);
        $insertStmt->bindParam(':transaction_time', $transaction_time);
        $insertStmt->bindParam(':month', $month);
        $insertStmt->bindParam(':week', $week);
        $insertStmt->bindParam(':day', $day);
        $insertStmt->bindParam(':new_receipt_no', $new_receipt_no);
        $insertStmt->bindParam(':invoiceNumber', $invoiceNumber);
        $insertStmt->bindParam(':offline_receipt', $offline_receipt);
        $insertStmt->bindParam(':comment', $comment);
        $insertStmt->bindParam(':invoiceDueDate', $invoiceDueDate);
        $insertStmt->bindParam(':payment_mode', $payment_mode);
        $insertStmt->bindParam(':bank_name', $bank_name);
        $insertStmt->bindParam(':bank_account_name', $bank_account_name);
        $insertStmt->bindParam(':business_category', $business_category);
        $insertStmt->bindParam(':pacra', $pacra);
        $insertStmt->bindParam(':tpin', $tpin);
        $insertStmt->bindParam(':org_name', $org_name);
        $insertStmt->bindParam(':org_id', $org_id);
        $insertStmt->bindParam(':lat', $deliverylat);
        $insertStmt->bindParam(':lng', $deliverylng);
        $insertStmt->bindParam(':delivery_address', $deliveryaddress);
        $insertStmt->bindParam(':area', $area);
        $insertStmt->bindParam(':plot_no', $plotnumber);
        $insertStmt->bindParam(':nrc', $nrc);
        $insertStmt->bindParam(':agent_name', $agent_name);
        $insertStmt->bindParam(':agent_id', $agent_id);
        $insertStmt->bindParam(':trans_type', $transtype);
        $insertStmt->bindParam(':debit_or_credit', $debit_or_credit);
        $insertStmt->bindParam(':order_details', $order_details);
        $insertStmt->bindParam(':product_name', $productname);
        $insertStmt->bindParam(':product_id', $product_id);
        $insertStmt->bindParam(':product_code', $product_code);
        $insertStmt->bindParam(':product_category', $product_category);
        $insertStmt->bindParam(':product_category_code', $product_category_code);
        $insertStmt->bindParam(':balance_bf', $balance_bf);
        $insertStmt->bindParam(':transaction_amount', $transaction_amount);
        $insertStmt->bindParam(':transaction_balance', $transaction_balance);
        $insertStmt->bindParam(':quantity', $quantity);
        $insertStmt->bindParam(':order_code', $order_code);
        $insertStmt->bindParam(':transaction_reference', $transaction_reference);
        $insertStmt->bindParam(':transaction_status', $transaction_status);
        $insertStmt->bindParam(':depot', $depot);
        $insertStmt->bindParam(':depot_id', $depot_id);
        $insertStmt->bindParam(':depot_code', $depot_code);

        if ($insertStmt->execute()) {
            echo json_encode([
                'status' => 'created',
                'date' => $transaction_date,
                'time' => $transaction_time,
                'receiptnumber' => $new_receipt_no,
                'offline_receipt' => $offline_receipt,
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Transaction insertion failed']);
        }
    }
}
?>
