<?php
require __DIR__ . '/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Path to your existing Excel file
$inputFileName = __DIR__ . '/sample-client-upload.xlsx';

// Check if file exists
if (!file_exists($inputFileName)) {
    // If not, create a new one
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue('A1', 'Name');
    $sheet->setCellValue('B1', 'Score');
    $sheet->setCellValue('A2', 'Alice');
    $sheet->setCellValue('B2', 90);
    $sheet->setCellValue('A3', 'Bob');
    $sheet->setCellValue('B3', 85);

    $writer = new Xlsx($spreadsheet);
    $writer->save($inputFileName);
    echo "Created initial example.xlsx file.<br>";
}

// Load the spreadsheet
$spreadsheet = IOFactory::load($inputFileName);
$sheet = $spreadsheet->getActiveSheet();

// Read a value
$name = $sheet->getCell('A2')->getValue();
$score = $sheet->getCell('B2')->getValue();
echo "Original Value: $name - $score<br>";

// Modify a value
$sheet->setCellValue('B2', $score + 5); // Alice’s new score +5

// Add a new row
$sheet->setCellValue('A4', 'Charlie');
$sheet->setCellValue('B4', 92);

// Save to a new file
$outputFileName = __DIR__ . '/example_modified.xlsx';
$writer = new Xlsx($spreadsheet);
$writer->save($outputFileName);

echo "Modified Excel saved as example_modified.xlsx";
