document.addEventListener("DOMContentLoaded", function () {
  const chatButton = document.getElementById("chatButton");
  const chatWindow = document.getElementById("chatWindow");
  const closeChat = document.getElementById("closeChat");
  const attachFile = document.getElementById("attachFile");
  const fileInput = document.getElementById("fileInput");
  const emojiButton = document.getElementById("emojiButton");
  const voiceButton = document.getElementById("voiceButton");

  let isDragging = false;
  let offsetX, offsetY;

  // Open Chat Window
  chatButton.addEventListener("click", function () {
    if (!isDragging) {
      chatWindow.style.transform = chatWindow.style.transform === "scale(1)" ? "scale(0)" : "scale(1)";
    }
    getMessengerChats();

  });

  closeChat.addEventListener("click", function () {
    chatWindow.style.transform = "scale(0)";
  });

  // Drag Start
  chatButton.addEventListener("mousedown", function (e) {
    isDragging = true;
    offsetX = e.clientX - chatButton.getBoundingClientRect().left;
    offsetY = e.clientY - chatButton.getBoundingClientRect().top;
    chatButton.style.transition = "none"; // Disable transition while dragging
 
  });

  // Drag Move
  document.addEventListener("mousemove", function (e) {
    if (isDragging) {
      let x = e.clientX - offsetX;
      let y = e.clientY - offsetY;
      chatButton.style.left = `${x}px`;
      chatButton.style.top = `${y}px`;
    }
  });

  // Drag End
  document.addEventListener("mouseup", function () {
    isDragging = false;
    chatButton.style.transition = "0.3s ease-in-out"; // Re-enable transition after dragging
  });

  // File Attachment
  attachFile.addEventListener("click", function () {
    fileInput.click();
  });

  fileInput.addEventListener("change", function () {
    alert("File selected: " + fileInput.files[0].name);
  });

  // Emoji Button (Placeholder Action)
  emojiButton.addEventListener("click", function () {
    alert("Emoji Picker coming soon! 😊");
  });

  // Voice Button (Placeholder Action)
  voiceButton.addEventListener("click", function () {
    alert("Voice Recording feature coming soon! 🎤");
  });

  // Close chat when clicking outside (on mobile)
  document.addEventListener("click", function (event) {
    if (!chatWindow.contains(event.target) && !chatButton.contains(event.target)) {
      chatWindow.style.transform = "scale(0)";
    }
  });
});






////////// SEARCH INPUT SCRIPTS//////
document.addEventListener("DOMContentLoaded", function () {
  const searchIcon = document.getElementById("searchIcon");
  const closeSearch = document.getElementById("closeSearch");
  const searchContainer = document.getElementById("searchContainer");
  const searchInput = document.getElementById("searchInput");
  const closeChat = document.getElementById("closeChat");
  const chatTitle = document.querySelector(".chat-title");
  const chatDropDown = document.querySelector(".chatDropDown");
  const filterIcons = document.querySelectorAll(".filter-icon"); 

  // Expand search bar
  searchIcon.addEventListener("click", function () {
    searchContainer.classList.add("expanded");
    searchInput.focus();
    closeChat.style.display = "none"; // Hide close button
    chatTitle.style.display = "none"; // Hide chat title
   // chatDropDown.style.display = "none"; // Hide dropdown menu

  });

  // Close search
  closeSearch.addEventListener("click", function () {
    searchContainer.classList.remove("expanded");
    searchInput.value = "";

    // Show hidden elements
    closeChat.style.display = "inline";
    chatTitle.style.display = "inline";
    chatDropDown.style.display = "inline";
    chatDropDown.style.display = "inline";

    // Hide filter icons
    filterIcons.forEach(icon => icon.style.display = "none");
  });

  // Show filter icons when search is active
  searchInput.addEventListener("focus", function () {
    filterIcons.forEach(icon => icon.style.display = "inline");
  });

  // Unique Dropdown Menu
  const chatMenuIcon = document.getElementById("chatMenuIcon");

  chatMenuIcon.addEventListener("click", function () {
    chatDropDown.classList.toggle("active");
  });

  // Close dropdown if clicked outside
  document.addEventListener("click", function (event) {
    if (!chatDropDown.contains(event.target) && event.target !== chatMenuIcon) {
      chatDropDown.classList.remove("active");
    }
  });
});




///////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM///////////////////// SCRIPTS TO GET CHATS AND DISPLAY THEM//////////

function getMessengerChats() {
  var startDate = $("#workforceDataStartDate").val();
  var endDate = $("#workforceDataEndDate").val();
  var searchKey =  $("#workforceDataSearchInput1").val(); 
  var filterKey =  $("#workforceDataFilterSelectKey01").val();

  $('#main-body').empty().append('<div class="chatContainer w3-col l12 m12 s12"></div>');

   
var chatBoxModalContainer = ` 

<div class="chatContactListContainer w3-col l4 m4 s12">

<div  class="w3-col l12 m12 s12"> 

<div class="w3-col l12 m12 s12 chatContactListSearchContainer">
<div class="w3-col l11 m11 s11 w3-center">
<input id="workforceDataSearchInput1" type="text" placeholder="Search..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:40px;background-color:transparent;padding-left:7px;"/>
</div>

<div class="w3-col l1 m1 s1 w3-center">
  <span style="float:right"> 
  <select id="workforceDataFilterSelectKey01" style="background-color:transparent;border:none;outline:none;color:gray;max-width:15px;margin-top:10px;margin-right:10px;"><option value="All">All</option><option value="Unread">Active</option><option value="Pending">Read</option><option value="Suspended">Important</option></select>
</span>
</div>

</div> 

<div class="w3-col l12 m12 s12">
  <div class="chatContactList w3-col l12 m12 s12"> 
 </div> 
 </div>

  
</div>

</div>  `;

  $('.chatContainer').append(chatBoxModalContainer);
  // Simple SVG for Chat Box
  var chatBoxMainDiv = `
   <div class="chatBoxMainDiv w3-col l12 m12 s12">

  <div class="chatBoxMainMessageContentDiv">

  <p>Chat with anyone on the system!</p> 
 
  </div>

  <div class="chatBoxMainInputDiv w3-bottom">

  <div class="w3-col l12 m12 s12">

    <div class="w3-col l12 m12 s12">
     <span class="fontx fx-mic" style="width:10%"></span>
  <input id="workforceDataSearchInput1" type="text" placeholder="Write your message..." style="width:50%;font-weight:400;outline:none;border:none;border-bottom:none;height:40px;background-color:transparent;padding-left:7px;"/>
   <span class="fontx fx-paperclip" style="width:10%"></span>
    <span class="fontx fx-meh" style="width:10%"></span>
     <span class="chatSendButton w3-center" style="width:20%;height:40px;width:40px;border-radius:50%;background-color:rgba(96, 146, 205,1);padding:10px;color:#eee;">
      <span class="fontx fx-send"></span>
     </span>
  </div>



  </div>


  </div>

  </div>
  `;

  $('.chatContainer').append('<div class="chatBoxDiv w3-col l8 m8 s12">' + chatBoxMainDiv+ '</div>');

   
  $('.chatBoxDiv').css({
      //  'background-image': 'url("xd-assets/images/chat-bckground.gif")',
        'background-size': 'cover',
        'background-position': 'center',
        'background-repeat': 'no-repeat',
        'height': '100%',
        'min-height': '400px'
      }); 
  var datastring = 'searchKey=' + searchKey + '&startDate=' + startDate + '&endDate=' + endDate + '&filterKey=' + filterKey;

  $.ajax({
      data: datastring,
      url: "xd-modules/admin-modules/backend/workforce.php",
      type: "POST"
  }).done(function (data) {
      try {
          var details = JSON.parse(data);
          $('.chatContactList').empty()
        $.each(details.details, function (i, freelance) {
              var userHTML = '<div data-id="' + freelance.id + '" data-avatar="' + freelance.avatar + '" data-names="' + freelance.names + '" class="contaactLisItem inner-data-div w3-col l12 m12 s12" style="cursor:pointer">' +
                  '<div class="w3-col l2 2 s2 userprofilePitureDiv"><center><img src="' + freelance.avatar + '" class="userProfilePicture" /></center></div>' +
                  '<div class="w3-col l10 m10 s10">' +
                  '<span class="w3-col l12 m12 s12" style="padding-left:7px;font-weight:600;color:gray;"><span>' + freelance.names + '</span> <i class="userOnlineStatusInnerDataDiv">23</i> <i class="userprofileRoleInnerDataDiv">' + freelance.role + '</i> </span>' +
                 
                  '<span class="w3-col l12 m12 s12">' +
                  '<span style="floaat:left;padding-leftt:10x;color:#3498db;;">Seen: '+freelance.lastlogin+'</span>' +
                  '</span></div></div>';

              $('.chatContactList').append(userHTML);
          });

         // $('.mainChatBoxDiv').append('<div class="w3-col l12 m12 s12 chatBoxDiv" style="margin-top:20px;text-align:left;font-weight:200;padding-left:12px;color:black;font-size:0.6em;font-weight:600;"><center style="margin-top:20%;">CHat Box</center></div>');
      } catch (e) {
          console.error("Error parsing JSON:", e);
      }
  });
}

///////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM/////////////////// END OF  SCRIPTS TO GET CHATS AND DISPLAY THEM//////////
