let previousUnseenCount = 0; // Store last unseen messages count
const notificationSound = new Audio("xd-assets/audios/notification-20-270145.mp3"); // Notification sound

// Step 1: Enable sound playback after user interaction (only needed once)
let isSoundEnabled = false; // Track if the sound has been enabled
document.addEventListener("click", () => {
    notificationSound.play().catch(err => console.log("Autoplay enabled after interaction:", err));
    isSoundEnabled = true; // Mark sound as enabled
}, { once: true });

// Step 2: Function to check for new messages & update gps_olie status of the user
function cyberDeskUpdateUnseenMessages() {
    $.ajax({
        url: "xd-modules/messenger-module/backend/get_total_new_messages.php",
        type: "POST",
        success: function (response) {
            try {
                let data = JSON.parse(response);

                if (data.total_unseen_messages !== undefined) {
                    let unseenCount = data.total_unseen_messages;
                    let chatBadge = document.querySelector(".chat-badge");

                    // Update chat badge
                    if (chatBadge) {
                        chatBadge.textContent = unseenCount > 0 ? unseenCount : "";
                    }

                    // Play sound only when a **new** message arrives
                    if (unseenCount > previousUnseenCount && isSoundEnabled) {
                        // Check if the tab is visible
                        if (document.visibilityState === "visible") {
                            notificationSound.play().catch(err => console.log("Audio play error:", err));
                        }
                    }

                    // Update previous count
                    previousUnseenCount = unseenCount;
                }
            } catch (error) {
                console.error("Error parsing JSON:", error);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error fetching unseen messages:", error);
        }
    });
}


// Step 3: Start interval when online
let cyberDeskIntervalId;
function cyberDeskStartInterval() {
    if (!cyberDeskIntervalId) {
        cyberDeskIntervalId = setInterval(() => {
            console.log("Checking for new messages...");
            cyberDeskUpdateUnseenMessages();
         }, 5000); // Every 5 seconds
    }
}

// Step 4: Stop interval when offline
function cyberDeskStopInterval() {
    if (cyberDeskIntervalId) {
        clearInterval(cyberDeskIntervalId);
        cyberDeskIntervalId = null;
        console.log("CyberDesk interval stopped.");
    }
}

// Step 5: Handle online/offline state
if (navigator.onLine) {
    cyberDeskStartInterval();
}
window.addEventListener("online", cyberDeskStartInterval);
window.addEventListener("offline", cyberDeskStopInterval);


function updateOnlieStatus() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            function (position) {
                var clat = position.coords.latitude;  // Get latitude
                var clon = position.coords.longitude; // Get longitude

                if (clat === '' || clon === '') {
                    console.log("Latitude or Longitude is empty.");
                } else {
                    var datastring = 'clat=' + clat + '&clon=' + clon;

                    $.ajax({
                        data: datastring,
                        url: "xd-assets/backend/gps_update.php",
                        type: "POST",
                        success: function (response) {
                            console.log("Location updated successfully:", response);
                        },
                        error: function (xhr, status, error) {
                            console.error("Error updating location:", error);
                        }
                    });
                }
            },
            function (error) {
                console.error("Error getting location:", error.message);
            },
            {
                enableHighAccuracy: true, // Request high accuracy for better results
                timeout: 30000,          // Timeout after 10 seconds
                maximumAge: 0            // Do not use cached location
            }
        );
    } else {
        console.error("Geolocation is not supported by this browser.");
    }
}

// Set an interval to call updateOnlieStatus() every 30 seconds
setInterval(updateOnlieStatus, 30000);


/////// END OF CYBERDESK INTERVAL FUNCTION/////////////// END OF CYBERDESK INTERVAL FUNCTION////////
/////// END OF CYBERDESK INTERVAL FUNCTION/////////////// END OF CYBERDESK INTERVAL FUNCTION////////

// Function to get the user data from IndexedDB
  function getUserFromIndexedDB() {
    return new Promise((resolve, reject) => {
        openUserDB().then((db) => {
            const transaction = db.transaction(['user'], 'readonly');
            const store = transaction.objectStore('user');
            const request = store.getAll(); // Fetch all user records
  
            request.onsuccess = function() {
                resolve(request.result); // Return the user data
            };
  
            request.onerror = function(e) {
                reject(e.target.error);
            };
        }).catch((error) => {
            reject(error);
        });
    });
  }

  //////  SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
   //////   SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
    //////  SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
     ///// / SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
 

setTimeout(function(){ 
  // Function to open the IndexedDB database for user data
  // Function to open the IndexedDB for the user
  function openUserDB() {
      return new Promise((resolve, reject) => {
          const request = indexedDB.open('userDB', 3); // Open IndexedDB with a version number (e.g., 1)
          
          request.onupgradeneeded = function(event) {
              const db = event.target.result;
              if (!db.objectStoreNames.contains('user')) {
                  db.createObjectStore('user', { keyPath: 'id' }); // Create user store with 'id' as the key
              }
          };
          
          request.onsuccess = function(event) {
              resolve(event.target.result); // Resolve with the database object
          };
          
          request.onerror = function(event) {
              reject('Failed to open the user database: ' + event.target.error);
          };
      });
  }
  
  
  // Function to clear the user data in IndexedDB
  function clearUserDataInIndexedDB() {
      return new Promise((resolve, reject) => {
          openUserDB().then((db) => {
              const transaction = db.transaction(['user'], 'readwrite');
              const store = transaction.objectStore('user');
  
              // Clear all user data in the store
              store.clear();
  
              transaction.oncomplete = function () {
                  resolve('User data cleared from IndexedDB');
              };
  
              transaction.onerror = function (e) {
                  reject(e.target.error);
              };
          }).catch((error) => {
              reject(error);
          });
      });
  }
  
  // Function to save new user data to IndexedDB
  function saveUserToIndexedDB(userData) {
      openUserDB().then((db) => {
          const transaction = db.transaction(['user'], 'readwrite');
          const store = transaction.objectStore('user');
          store.put(userData); // Add the new user data
  
          transaction.oncomplete = function () {
              console.log('New user data saved to IndexedDB');
          };
  
          transaction.onerror = function (e) {
              console.error('Error saving user data:', e.target.error);
          };
      });
  }
  
  // Example usage with session check
  
  $.getJSON('xd-assets/backend/sessioncheck.php', function (data) {
    if (data.status == 'loggedin') {
        clearUserDataInIndexedDB().then(() => {
            const userData = {
                id: data.sessiondata,
                username: data.username,
                avatar: data.avatar,
                userrole: data.userrole,
                phone: data.phone,
                email: data.email,
                address: data.address,
                orgname: data.orgname,
                orgid: data.orgid,
                org_p_o_box: data.org_p_o_box,
                org_logo: null, // We'll fetch and store as Blob
                org_address: data.org_address,
                org_contacts: data.org_contacts,
                org_email: data.org_email
            };

            // Fetch and store the logo as a Blob
            if (data.org_logo) {
                fetchAndStoreOrgLogo(data.org_logo, userData);
            } else {
                saveUserToIndexedDB(userData);
            }
        }).catch((error) => {
            console.error('Error clearing user data:', error);
        });
    }
});

// Function to fetch and store org logo as Blob
function fetchAndStoreOrgLogo(imageUrl, userData) {
    fetch(imageUrl)
        .then(response => response.blob())
        .then(blob => {
            userData.org_logo = blob; // Store Blob in IndexedDB
            saveUserToIndexedDB(userData);
        })
        .catch(error => {
            console.error('Error fetching org logo:', error);
            saveUserToIndexedDB(userData); // Save user data without logo if there's an error
        });
}

  getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
  .then((userData) => {
      if (userData.length > 0) {
          const user = userData[0]; // Assuming the first user record is the relevant one

          // Update the UI elements with user data 
          $('.org_name').empty().append(user.orgname);        
          $('#user_account_btn398').text(user.username); // Display username
          $('#user-role').text(user.phone);   
          // Check if the user has an org logo stored as a Blob
          if (user.org_logo) {
              // Convert Blob to a URL that can be used in the `img` element
              const logoURL = URL.createObjectURL(user.org_logo); 
              // Create an img element and set its source to the Blob URL
              const imgElement = $('<img>', {
                  src: logoURL,  // Set the image source (Blob URL)
                  alt: 'Logo', // Alt text for the image
                  class: 'waterMark showOnPrint w3-hide-small',   // Optional: Add a class for styling
              });

              // Append the image to the DOM
              $('.waterMarkDiv').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
          } else {
              console.error('No organization logo found in user data.');
          }

          // console.log('User data successfully displayed while offline:', user);
      } else {
          // console.error('No user data found in IndexedDB while offline.');
      }
  })
  .catch((error) => {
      console.error('Error retrieving user data from IndexedDB:', error);
  });


  
  //syncClientsToIndexedDB();
}, 8000);


/*
/// Saving openClientsDB ///
// 1) Open (and upgrade) the clients DB exactly like your userDB
function openClientsDB() {
  return new Promise((resolve, reject) => {
    const req = indexedDB.open('clientsDB', 1);
    req.onupgradeneeded = e => {
      const db = e.target.result;
      if (!db.objectStoreNames.contains('clients')) {
        const store = db.createObjectStore('clients', { keyPath: 'id' });
        store.createIndex('names', 'names', { unique: false });
        store.createIndex('phone', 'phone', { unique: false });
      }
    };
    req.onsuccess = e => resolve(e.target.result);
    req.onerror   = e => reject(e.target.error);
  });
}

// 2) Clear & refill your clients store
 function syncClientsToIndexedDB() {
  // 1) fetch all the clients
  $.getJSON('xd-modules/agent-module/backend/allClients.php')
    .done(data => {
      // 2) once we have the data, open the DB
      openClientsDB()
        .then(db => {
          const tx    = db.transaction('clients', 'readwrite');
          const store = tx.objectStore('clients');

          // clear out the old clients
          store.clear();

          // put each active client into that same tx
          data.freelancedetails.forEach(freelance => {
            if (freelance.status === 'active') {
              store.put({
                id:                            freelance.id,
                names:                         freelance.names,
                org_name:                      freelance.org_name,
                phone:                         freelance.phone,
                email:                         freelance.email,
                address:                       freelance.address,
                business_category:             freelance.business_category,
                company_registration_number:   freelance.company_registration_number,
                tpin:                          freelance.tpin,
                nrc:                           freelance.nrc,
                plot_number:                   freelance.plot_number,
                area:                          freelance.area
              });
            }
          });

          // 3) watch for success / failure
          tx.oncomplete = () => {
            console.log('✅ clientsDB sync complete. Stored:',
                        data.freelancedetails.filter(f => f.status === 'active').length,
                        'records.');
          };
          tx.onerror = () => {
            console.error('❌ Transaction failed:', tx.error);
          };
        })
        .catch(err => console.error('clientsDB open error:', err));
    })
    .fail((jqXhr, status, err) => {
      console.error('Failed to fetch clients:', status, err);
    });
}

*/

 


  ////// end of SAVING USER's DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
   ////// end of SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
    ////// end of SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////
     ////// end of SAVING USER DATA TO INDEXEDDB //////// ////// end of SAVING USER DATA TO INDEXEDDB ////////

$(document).on('click','.closeModal',function (event) { 
	event.preventDefault(); 
     $('.w3-modall').fadeOut('slow');
	  
}); 
$(document).on('click','.close_modal99',function (event) {
	
	event.preventDefault();
     //$('#add_news_content_modal').fadeOut('slow');
     $('#edit_account_response_modal').fadeOut('slow');
	 
	 $("#add_news_content_form0946").trigger('reset'); //jquery
	 $("#upload_news_form0946").trigger('reset'); //jquery
     			  	      
}); 



$(document).on('click','.downloadData',function (event) { 
  event.preventDefault(); 
  event.stopPropagation(); 
 // var count= document.querySelectorAll("input[name='invoicecheckbox101']:checked").length;
 var startDate = document.getElementById("revenueReportStartDate").value;
  var endDate = document.getElementById("revenueReportEndDate").value;
  var searchKey = document.getElementById("searchRevenueReport101").value; 
  var selectedText = $('.revenueReportSelectKey101 option:selected').text();
 // var selectedValue = $('.revenueReportSelectKey101').val();

  $('#flexibleModal').fadeIn('slow');
  $('#flexibleModal').empty().append(`
    <div style="display: flex; align-items: center; justify-content: center;">
        <div class="w3-col l12 m12 s12 w3-center" 
            style="background-color: rgba(255,255,255,0.8); width: 40%; padding: 10px; border-radius: 5px;">
            <div id="flexibleModal_controls" class="w3-col l12 m12 s12"><span class="fontx fx-x closeModal" style="color:red;font-size:1.5em;float:right;cursor:pointer"></span></div> 
            <div id="flexibleModal_title" class="w3-col l12 m12 s12"><span class="fontx fx-download" style="color:var(--primary-color); font-size: 3em;border:10px solid var(--primary-color-transparent);border-radius:50%;background-color:rgba(96, 146, 205, 0.2);"></span></div>
            <div id="flexibleModal_body" class="w3-col l12 m12 s12"></div>
        </div>
    </div>
`); 

  $('#flexibleModal_body').append('<p>You are about to download <b>'+selectedText+' '+searchKey+'</b> data from <b style="color:var(--primary-color);">'+startDate+'</b>  to <b style="color:var(--primary-color);">'+endDate+'</b>. Click the icon of  the format you want to download your data.</p>');
   
  $('#flexibleModal_body').append('<a href="#" id="excelDownload101"><img src="xd-assets/img/excel.jpg" style="height:50px;width:60px;margin:5px;"/></a>');
    $('#flexibleModal_body').append('<a href="#" id="downloadReport101" ><img src="xd-assets/img/csv.png" style="height:50px;width:60px;margin:5px;"/></a>');
   $('#flexibleModal_body').append('<a href="#" id="downloadReport101" ><img src="xd-assets/img/sql.png" style="height:50px;width:60px;margin:5px;"/></a>');
    
});

//downloadReport101

$(document).on('click','#downloadReport101',function (event) { 
  event.preventDefault(); 
  event.stopPropagation(); 
  //$('#general-modal713').fadeOut('slow');
  $('#flexibleModal_body').empty();
	$('#flexibleModal_body').append('<center style="margin-top:20%;" ><div class="body-loader"></div><br/></center>');
  setTimeout(function(){ 
    $('#flexibleModal_body').empty();
    $('#flexibleModal_body').append('<p>These data format is not currently available. Contact support!<p>');
    }, 2000);
 
  }); 

 


$(document).on('click', '.checkThemAll', function(event){ 
    if(this.checked) {
        // Iterate each checkbox
        $(':checkbox').each(function() {
            this.checked = true;                        
        });
    } else {
        $(':checkbox').each(function() {
            this.checked = false;                       
        });
    }
});

 
$(document).on('click', '.mainPrintBtn102, .printReceiptBtn102', function(event){ 
  
  $('.orge-credentials101').show();
  $('.showOnPrint').show();
  $('.hideOnPrint').hide();
  $('.fontx').hide();
  setTimeout(function(){  
    window.print();
     }, 1000);

     setTimeout(function(){  
      $('.orge-credentials101').hide();
      $('.hideOnPrint').show();
      $('.showOnPrint').hide();
      $('.fontx').show();
       }, 3000);  
});
$(document).on('click', '.closeModal', function(event){ 
  
  $('.w3-modal').fadeOut('slow');
  $('#watermark34').fadeOut('slow');
});
/* */

// FUCTIO TO SHOW THE TOTAL SELECTED ITEMS
$(document).on('click', '.transactioncheckbox', function(event){ 
    if(this.checked) {
     // alert('Checked!');
       var mySelect101 = $('#selectedDeposits101').html();
       var decrementSelected= ++mySelect101;
       $('#selectedDeposits101').html(decrementSelected);
      
    } else {
   // alert('Un checked!');
      var mySelect101 = $('#selectedDeposits101').html();
      var incremetSelected= --mySelect101;
      $('#selectedDeposits101').html(incremetSelected);
    }
  });
  // FUCTIO TO SHOW THE TOTAL SELECTED ITEMS

  
  
function numberToWords(num) {
  if (num === 0) return "zero";

  const ones = ["", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"];
  const teens = ["", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"];
  const tens = ["", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"];
  const thousands = ["", "thousand", "million", "billion"];

  function convertToWords(n) {
      if (n === 0) return "";
      else if (n < 10) return ones[n];
      else if (n < 20) return teens[n - 10];
      else if (n < 100) return tens[Math.floor(n / 10)] + (n % 10 ? " " + ones[n % 10] : "");
      else if (n < 1000) return ones[Math.floor(n / 100)] + " hundred" + (n % 100 ? " " + convertToWords(n % 100) : "");
      else {
          for (let i = 0; i < thousands.length; i++) {
              let unit = Math.pow(1000, i + 1);
              if (n < unit) {
                  return convertToWords(Math.floor(n / (unit / 1000))) + " " + thousands[i] + (n % (unit / 1000) ? " " + convertToWords(n % (unit / 1000)) : "");
              }
          }
      }
  }

  return convertToWords(num);
}

function convertToKwachaWords(amount) {
  const kwacha = Math.floor(amount);
  const ngwee = Math.round((amount - kwacha) * 100);

  let kwachaWords = numberToWords(kwacha) + " kwacha";
  let ngweeWords = ngwee > 0 ? " and " + numberToWords(ngwee) + " ngwee" : "";

  return kwachaWords + ngweeWords + " only";
}

function updateDivClass() {
  const myDivs = document.querySelectorAll(".invoiceDivActions101");
  const isSmallScreen = window.innerWidth <= 600;

  myDivs.forEach(myDiv => {
    myDiv.classList.toggle("w3-bottom", isSmallScreen);
    myDiv.classList.toggle("w3-top", !isSmallScreen);
  });
}


function updateDivClass() {
  const myDivs = document.querySelectorAll(".invoiceDivActions101");
  const isSmallScreen = window.innerWidth <= 600;

  myDivs.forEach(myDiv => {
    myDiv.classList.toggle("w3-bottom", isSmallScreen);
    myDiv.classList.toggle("w3-top", !isSmallScreen);
  });
}

// Observe changes in the DOM for dynamically added elements
const observer = new MutationObserver(() => {
  updateDivClass();
});

// Start observing the document body for child additions
observer.observe(document.body, { childList: true, subtree: true });

// Update on window resize
window.addEventListener("resize", updateDivClass);

// Initial call for existing elements
updateDivClass();

 

  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
    ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
    ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
  let startX;
  
  document.addEventListener('touchstart', function(event) {
      startX = event.touches[0].clientX; // Get the initial touch position on the X axis
  }, false);
  
  document.addEventListener('touchend', function(event) {
      let endX = event.changedTouches[0].clientX; // Get the final touch position on the X axis
      handleSwipe(startX, endX); // Pass the start and end positions to the swipe handler function
  }, false);
  
  function handleSwipe(startX, endX) {
      let threshold = 200; // Minimum swipe distance in pixels
      let diffX = startX - endX;
  
      if (Math.abs(diffX) > threshold) { // Check if the swipe distance exceeds the threshold
          if (diffX > 0) {
              // Left swipe
              console.log("Swiped left"); 
              transact101(); 
               // calling the function  addProductToReceipt101() from xd-assets/js/products.js line 193
              addProductToReceipt101();
          } else {
              // Right swipe
              console.log("Swiped right");
             // alert("Swiped right");
               createClient101(); 
          }
      }
  }

    ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
    ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
   ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
    ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS  ///////// lEFT AND RIGHT SWIPE ACTIONS
 



    ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
    ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
    ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
    ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
   
    $(document).on('click','.loginnResetCodes0',function (event) {
      let today = new Date().toISOString().slice(0, 10);
      $('#page-options').empty(); 
      $('#page-options').append('<select class="resetCodesSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="Reset Codes">Reset Codes</option></select> <span id="record01"></span>');
     $('#right_nav_options0').empty();
      $('#right_nav_options0').append('<a href="#" id="bankAccountDepositIconDiv" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file depositSlipIcon1"></span></a>');
     
      $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
      $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102  w3-hide-small top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
     $('#right_nav_options0').append('<div id="exportTransactioins" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-share-2"></span></div>');
     $('#right_nav_options0').append('<div  class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
      
      
      $('#sub_top_nav').empty(); 
      $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s7 w3-center"><input id="searchResettCodes101" type="text" placeholder="Type to search..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s5 w3-center" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span><select id="resetCodesDisplayType" style="background-color:transparent;border:none;outline:none;color:gray;"><option value="Charts">Charts</option><option value="Normal">Normal</option><option value="Display All">Display All</option><option value="Map">Map</option></select></span><div/></div><div class="w3-col l5 m5 s12 w3-center" style="padding-left:7px;padding-top:3px;color:gray;background-color:;"><span style="float:right;"><input type="date" value="'+today+'" id="resetCodeStartDate" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/><input type="date" value="'+today+'" id="resetCodeEndDate" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/></span></div>');
     
      oginnResetCodes101();
  });


  $(document).on('change keyup','#searchResettCodes101, #resetCodeStartDate, #resetCodeEndDate',function (event) {
    oginnResetCodes101();
  });
  
   function oginnResetCodes101() {
    var startDate = document.getElementById("resetCodeStartDate").value;
    var endDate = document.getElementById("resetCodeEndDate").value;
    var searchKey = document.getElementById("searchResettCodes101").value;
    // Create an object with data to send in the AJAX request
    var data = {
        startDate: startDate,
        endDate: endDate,
        searchKey: searchKey
    };
    $.ajax({
        url: "xd-assets/backend/resetCodes.php", // Path to your resetCodes.php file
        type: "POST", // Use GET or POST depending on your backend implementation
        data: data,
        success: function (response) {
            try {
                // Parse the response if it's in JSON format
                let data = JSON.parse(response);
               if(data.numofrows==0){
                $('#main-body').append('<center><p style="margin-top:10%;color:red;">No reseet codes for this date: '+startDate+' To '+endDate+' </p></center>');
                }
                // Check if the response contains reset codes
                if (data) {
                    // Display the reset codes (you can customize this as needed)
                    $('#main-body').empty();
                    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" style="font-weight:600;"><div class="w3-col l2 m2 s12" style="padding-left:10px;"> Timestamp</div><div class="w3-col l2 m2 s12">Reset Code</div><div class="w3-col l3 m3 s12"> Requested By</div><div class="w3-col l2 m2 s12">Phone Number</div><div class="w3-col l3 3 s12">Email</div></div>');
                   $.each(data.details, function(i, cyberdesk) {
                    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12"  style="cursor:pointer" data-resecodeid"'+cyberdesk.id+'"><div class="w3-col l2 m3 s6"><span style="font-weight:400;color:;margin-left:7px;color:#6092cd"><b>'+cyberdesk.timestamp+'</b> </span></div><div class="w3-col l2 m2 s6"><b style="margin-left:6px;"><span class="w3-hide-large w3-hide-medium" style="color:var(--primary-color);">Rpt No: </span><span style="color:red;">'+cyberdesk.temppass+'</span></b></div><div class="w3-col l3 m3 s8" style="padding-left:5px;text-transform:capitalize"> '+cyberdesk.names+'</div><div class="w3-col 2 m2 s3" style="font-weight:400;color:var(--primary-color);"><span> '+cyberdesk.phone+'</span></div><div class="w3-col l3 m3 s8" style="padding-left:5px;"> '+cyberdesk.email+'</div></div>');
                    });  
                } else {
                    $('#main-body').append('<center><p style="margin-top:10%;color:red;">No data found!</p></center>');
                }

            } catch (error) {
                console.error("Error parsing response:", error);
                alert("An error occurred while fetching reset codes.");
            }
        },
        error: function (xhr, status, error) {
            console.error("Error fetching reset codes:", error);
            alert("Failed to fetch reset codes. Please try again later.");
        }
    });
}
 
  ///////// end of LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
  ///////// end of LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
    ///////// end of LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
  ///////// end of LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
     ///////// end of LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
  ///////// end of LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES ///////// LOGIN RESET CODES///////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ///////////////// LOGIN RESET CODES ////////
   


  //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// 
  //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// 
  //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// 
  //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// //////// HORIZONTAL SCROLL //// 
 // Auto-scroll functionality for horizontal menu
class HorizontalScrollMenu {
    constructor(containerSelector) {
        this.container = document.querySelector(containerSelector);
        this.buttons = this.container.querySelectorAll('button');
        this.init();
    }

    init() {
        // Add click handlers to all buttons
        this.buttons.forEach(button => {
            button.addEventListener('click', (e) => {
                this.setActive(e.currentTarget);
                this.scrollToButton(e.currentTarget);
            });
        });

        // Set first button as active by default
        if (this.buttons.length > 0) {
            this.setActive(this.buttons[0]);
        }
    }

    setActive(activeButton) {
        // Remove active class from all buttons
        this.buttons.forEach(btn => btn.classList.remove('active'));
        
        // Add active class to clicked button
        activeButton.classList.add('active');
    }

    scrollToButton(button) {
        const containerRect = this.container.getBoundingClientRect();
        const buttonRect = button.getBoundingClientRect();
        
        // Calculate the button's position relative to the container
        const buttonLeft = buttonRect.left - containerRect.left;
        const buttonCenter = buttonLeft + (buttonRect.width / 2);
        const containerCenter = containerRect.width / 2;
        
        // Calculate scroll position to center the button
        const scrollLeft = this.container.scrollLeft + buttonCenter - containerCenter;
        
        // Smooth scroll to position
        this.container.scrollTo({
            left: scrollLeft,
            behavior: 'smooth'
        });
    }

    // Method to programmatically set active button by ID
    setActiveById(buttonId) {
        const button = document.getElementById(buttonId);
        if (button) {
            this.setActive(button);
            this.scrollToButton(button);
        }
    }
}

// Initialize the menu when DOM is ready
document.addEventListener('DOMContentLoaded', () => {
    const menu = new HorizontalScrollMenu('.cyber-horizontal-scroll');
    
    // Example: You can also set active button programmatically
    // menu.setActiveById('automatic-billing-history-btn');
    
    // Make menu instance globally accessible if needed
    window.horizontalMenu = menu;
});


    // Add click handlers for filter buttons
// For buttons - handle active state
 // For buttons - handle active state
 $(document).on('click', '.cyber-horizontal-scroll button', function() {
  $('.cyber-horizontal-scroll button').removeClass('active');
    $('.cyber-horizontal-scroll select').removeClass('active');
    $(this).addClass('active');
});
 $(document).on('click', '.cyber-horizontal-scroll select', function() {
   $('.cyber-horizontal-scroll button').removeClass('active');
    $('.cyber-horizontal-scroll select').removeClass('active');
    $(this).addClass('active');
});
 