<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (empty($_FILES) || !isset($_FILES['avatar'])) {
        $json_data = array(
            'status' => 'nodatasenttoserver'
        );

        echo json_encode($json_data);  // send data as json format
        exit;
    } else {
        $sourcePath = $_FILES['avatar']['tmp_name']; // Storing source path of the file in a variable
        $field_upload = explode('.', $_FILES['avatar']['name']);
        $new_name = rand() . '.' . end($field_upload); // Use end() to get the file extension
        $targetPath = "../../xd-uploads/user-pictures/" . $new_name; // Target path where file is to be stored

        if (move_uploaded_file($sourcePath, $targetPath)) {
            $userloggedid = $_SESSION["userid"];
            require_once 'config/dbconfig.php';
            $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);

            // set the PDO error mode to exception
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // Store the full path in the database
            $imagePath = "xd-uploads/user-pictures/" . $new_name;
            $postingquery = "UPDATE `users` SET `avatar`=:imagePath WHERE id=:userloggedid";
            $insertposting = $conn->prepare($postingquery);
            $insertposting->bindParam(':imagePath', $imagePath);
            $insertposting->bindParam(':userloggedid', $userloggedid);

            $result = $insertposting->execute();

            if ($result === TRUE) {
                $json_data = array(
                    'status' => 'Image uploaded successfully'
                );

                echo json_encode($json_data);  // send data as json format
                exit;
            } else {
                unlink($targetPath); // Delete the uploaded file if database update fails

                $json_data = array(
                    'status' => 'notposted'
                );

                echo json_encode($json_data);  // send data as json format
                exit;
            }
        } else {
            $json_data = array(
                'status' => 'notuploaded'
            );

            echo json_encode($json_data);  // send data as json format
            exit;
        }
    }
} else {
    $json_data = array(
        'status' => 'invalidrequest'
    );

    echo json_encode($json_data);  // send data as json format
    exit;
}
?>
