<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

require_once 'config/dbconfig.php';

$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if (isset($_POST["rc"])) {
    
    $rc = $_POST["rc"] ?? null;
    $np = $_POST["np"] ?? null;

    if (!$rc || !$np) {
        echo json_encode(["status" => "error", "message" => "Missing data"]);
        exit;
    }
    
    // Fetch user ID from temp password table
    $sql = "SELECT user_id,org_id FROM temproal_password WHERE temppass = :rc 
            AND timestamp >= DATE_SUB(NOW(), INTERVAL 20 MINUTE) 
            ORDER BY timestamp DESC LIMIT 1";
    
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':rc', $rc);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$row) {
        echo json_encode(["status" => "error", "message" => "Invalid reset code"]);
        exit;
    }

    $user_id = $row["user_id"];
    $org_id = $row["org_id"];
    
    // Hash the new password
    $hashedPassword = password_hash($np, PASSWORD_DEFAULT);

    // Debug logs
    error_log("Raw password before hashing: " . $np);
    error_log("Hashed password: " . $hashedPassword);

    // Update the password
    $sql6 = "UPDATE users SET password = :np WHERE id = :user_id AND user_id=:org_id LIMIT 1";
    $stmt = $conn->prepare($sql6);
    $stmt->bindParam(':np', $hashedPassword);
    $stmt->bindParam(':user_id', $user_id);
    $stmt->bindParam(':org_id', $org_id);
    $stmt->execute();
    
    echo json_encode(['status' => 'success']);
    exit;
}
?>
