<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once 'config/dbconfig.php';

// Establish PDO connection
$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); 

// Retrieve session and input parameters
$agentname = $_SESSION["username"];
$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];
$bankid = filter_input(INPUT_POST, "bankid");
$bankname = filter_input(INPUT_POST, "bankname");
$accountname = filter_input(INPUT_POST, "accountname"); 
$accountnumber = filter_input(INPUT_POST, "accountnumber");
$bankbranch = filter_input(INPUT_POST, "bankbranch");
$swiftcode= filter_input(INPUT_POST, "swiftcode");
$sortcode = filter_input(INPUT_POST, "sortcode");
$bankstatus = filter_input(INPUT_POST, "bankstatus");  

// Update SQL query to update existing bank account where bank_id = :bankid
$updateBankAccountQuery = "UPDATE bank_accounts SET bank_name = :bankname, account_name = :accountname, branch = :bankbranch, account_number = :accountnumber, swift_code = :swiftcode, sort_code = :sortcode, account_status = :bankstatus, org_id = :orgid, sessionUserId = :userloggedid WHERE bank_id = :bankid";

$updateBankAccount = $conn->prepare($updateBankAccountQuery);

// Bind parameters to the prepared statement
$updateBankAccount->bindParam(':bankname', $bankname);
$updateBankAccount->bindParam(':accountname', $accountname);
$updateBankAccount->bindParam(':accountnumber', $accountnumber);
$updateBankAccount->bindParam(':bankbranch', $bankbranch);
$updateBankAccount->bindParam(':swiftcode', $swiftcode);
$updateBankAccount->bindParam(':sortcode', $sortcode);
$updateBankAccount->bindParam(':bankstatus', $bankstatus); 
$updateBankAccount->bindParam(':userloggedid', $userloggedid); 
$updateBankAccount->bindParam(':orgid', $orgid);
$updateBankAccount->bindParam(':bankid', $bankid);

// Execute the prepared statement
$updateBankAccount->execute();

// Check if the update was successful
if ($updateBankAccount->rowCount() > 0) {
    $json_data = array(
        'status' => 'Updated'
    );
} else {
    $json_data = array(
        'status' => 'not updated'
    );
}

// Return JSON response
echo json_encode($json_data);
exit;

?>
