<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
session_start();
require_once 'config/dbconfig.php';

$response = ['status' => 'notupdated'];

try {
    if (!isset($_SESSION["userid"])) {
        throw new Exception('User not logged in');
    }
    if (empty($_POST['passwordchange'])) {
        throw new Exception('No password provided');
    }
    $userloggedid = $_SESSION["userid"];
    $passwordChange = $_POST['passwordchange'];
    $hashedPassword = password_hash($passwordChange, PASSWORD_DEFAULT);

    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $updateQuery = "UPDATE users SET password = :hashedPassword WHERE id = :userid";
    $stmt = $conn->prepare($updateQuery);
    $stmt->bindParam(':hashedPassword', $hashedPassword);
    $stmt->bindParam(':userid', $userloggedid);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $response['status'] = 'updated';
    }
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
exit;
?>