<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
// Insert into the database after successful upload of the database
require_once 'config/dbconfig.php';

// Fetch input data securely
$startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
$endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);
$searchKey = filter_input(INPUT_POST, "searchKey");
//$userloggedid = $_SESSION["userid"]; 
//$orgid = $_SESSION["orgid"];

$conditions = [];
$parameters = [];

if (!empty($searchKey)) {
    $conditions[] = "(users.names LIKE :search_key OR users.phone LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
}
// Add date range condition
$conditions[] = "timestamp BETWEEN :startDate AND :endDate";
$parameters[':startDate'] = $startDateInput;
$parameters[':endDate'] = $endDateInput;

// Query to get revenue collector transaction totals
$getproductsquery = "
    SELECT 
     temproal_password.id,temproal_password.temppass,temproal_password.user_id,temproal_password.timestamp,users.names,users.phone,users.email
    FROM temproal_password
    LEFT JOIN users ON users.id = temproal_password.user_id
    WHERE " . implode(" AND ", $conditions) . " 
    ORDER BY temproal_password.timestamp DESC";

$getproducts = $conn->prepare($getproductsquery);
foreach ($parameters as $key => $value) {
    $getproducts->bindValue($key, $value);
}
$getproducts->execute();

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        'numofrows' => 0,
        'details' => [], 
    );
    echo json_encode($json_data);
    exit;
}

$totalrecords = $getproducts->rowCount();  
$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row; 
}

$json_data = array(  
    'details' => $nestedData, 
    'numofrows' => $totalrecords
);

echo json_encode($json_data);  // send data as json format
exit;
?>

