<?php
// reset_passwords.php
header('Content-Type: application/json');

require_once 'config/dbconfig.php';

try {
    $conn = new PDO(
        "mysql:host=$servername;dbname=$database;charset=utf8mb4",
        $username,
        $password,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    // === CONFIG ===
    // List of emails to reset
    $emails = [
        'aisupport@cyberdesk.live',
        'chinyamamuwawa@gmail.com',
        'harrykakono@gmail.com',
        'mukelanamasiku7@gmail.com',
        'costamulunga@gmail.com',
        'mosesshiyumba@gmail.com',
        'liliankashweka@yahoo.com',
        'twaambohimaindamulambo@gmail.com',
        'tizifabanda@gmail.com',
        'chipipakalimbwe@gmail.com',
        'simonchizenga@gmail.com',
        'webbykubanja@gmail.com',
        'mwangalalingomba@gmail.com',
        'chitumbocharles@gmail.com'
    ];

    // Set to true if you want to reset ALL users in the table
    $reset_all = false;

    // Fixed password for all users
    $plainPassword = "1234";
    $hashedPassword = password_hash($plainPassword, PASSWORD_DEFAULT);

    $updateStmt = $conn->prepare("UPDATE users SET password = :password WHERE email = :email LIMIT 1");
    $checkStmt  = $conn->prepare("SELECT id FROM users WHERE email = :email LIMIT 1");

    $results = [];
    $conn->beginTransaction();

    if ($reset_all) {
        $stmt = $conn->query("SELECT email FROM users");
        $targetEmails = $stmt->fetchAll(PDO::FETCH_COLUMN) ?: [];
    } else {
        $targetEmails = array_values(array_unique(array_filter($emails)));
    }

    foreach ($targetEmails as $email) {
        $email = trim($email);
        if ($email === '') continue;

        $checkStmt->execute([':email' => $email]);
        $user = $checkStmt->fetch();

        if (!$user) {
            $results[] = ['email' => $email, 'status' => 'not_found'];
            continue;
        }

        $updateStmt->execute([':password' => $hashedPassword, ':email' => $email]);
        error_log("Password reset to 1234 for {$email} (user_id={$user['id']})");

        $results[] = [
            'email' => $email,
            'status' => 'updated',
            'new_password' => $plainPassword
        ];
    }

    $conn->commit();

    echo json_encode([
        'status' => 'success',
        'count' => count($results),
        'results' => $results
    ], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    if (isset($conn) && $conn->inTransaction()) {
        $conn->rollBack();
    }
    error_log("Password reset error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error',
        'details' => $e->getMessage()
    ]);
    exit;
}
