<?php
require_once 'config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Query to fetch all users with plain text passwords
    $getusersquery = "SELECT id, password FROM users";
    $getusers = $conn->prepare($getusersquery);
    $getusers->execute();
    $users = $getusers->fetchAll(PDO::FETCH_ASSOC);

    // Loop through each user and update the password
    foreach ($users as $user) {
        $hashedPassword = password_hash($user['password'], PASSWORD_DEFAULT);

        // Update the password in the database
        $updatePasswordQuery = "UPDATE users SET password = :hashedPassword WHERE id = :userid";
        $updatePasswordStmt = $conn->prepare($updatePasswordQuery);
        $updatePasswordStmt->bindParam(':hashedPassword', $hashedPassword);
        $updatePasswordStmt->bindParam(':userid', $user['id']);
        $updatePasswordStmt->execute();

        echo "Password updated for user ID: " . $user['id'] . "\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
