<?php
 ini_set('display_errors', 1);
 ini_set('display_startup_errors', 1);
 error_reporting(E_ALL);
 
 // Log errors to a specific file
 ini_set('log_errors', 1);
 ini_set('error_log', 'error.log'); // Change this to a writable path on your server
 
 header('Access-Control-Allow-Origin: *');
 header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
 
 session_start();
 
 if ($_SERVER['REQUEST_METHOD'] == 'POST') {
     if (empty($_POST['e']) || empty($_POST['p'])) {
         echo json_encode(["status" => 'notalldataposted']);
         exit;
     }
 
     $e = filter_input(INPUT_POST, "e", FILTER_SANITIZE_EMAIL);
     $p = $_POST['p']; // Kept as is for password verification
 
     require_once 'config/dbconfig.php';
 
     try {
         $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
         $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
 
         // Get user details based on email or phone
         $getusersquery = "SELECT * FROM users WHERE (email=:e OR phone=:e)";
         $getusers = $conn->prepare($getusersquery);
         $getusers->bindParam(':e', $e);
         $getusers->execute();
         $getusers->setFetchMode(PDO::FETCH_ASSOC);
 
         if ($getusers->rowCount() == 0) {
             echo json_encode(['totalrecords' => 0]);
             exit;
         }
 
         $userFound = false;
         while ($row = $getusers->fetch()) {
             if (password_verify($p, $row['password'])) {
                 $_SESSION['userid'] = $row['id'];
                 $_SESSION['username'] = $row['names'];
                 $_SESSION['avatar'] = $row['avatar'];
                 $_SESSION['userrole'] = $row['role'];
                 $_SESSION['phone'] = $row['phone'];
                 $_SESSION['email'] = $row['email'];
                 $_SESSION['address'] = $row['address'];
                 
                 // Get org_id from clients or workforce table where user_id matches
                 $orgId = null;
                 // Try clients table first
                 $orgQuery = "SELECT org_id FROM user_roles WHERE user_id = :uid LIMIT 1";
                 $orgStmt = $conn->prepare($orgQuery);
                 $orgStmt->bindParam(':uid', $row['id']);
                 $orgStmt->execute();
                 $orgRow = $orgStmt->fetch(PDO::FETCH_ASSOC);
                 if ($orgRow && isset($orgRow['org_id'])) {
                     $orgId = $orgRow['org_id'];
                 } 
                 $_SESSION['orgid'] = $orgId;
 
                 $current_userid = $_SESSION['userid'];
                 $current_username = $_SESSION['username'];
 
                 // Fetch organization details
                 $getOrgQuery = "SELECT org_name,address, p_o_box, contact_number, email, logo FROM organizations WHERE id = :org_id";
                 $getOrgStmt = $conn->prepare($getOrgQuery);
                 $getOrgStmt->bindParam(':org_id', $_SESSION['orgid']);
                 $getOrgStmt->execute();
                 $orgDetails = $getOrgStmt->fetch(PDO::FETCH_ASSOC);
 
                 if ($orgDetails) {
                     $_SESSION['orgname'] = $orgDetails['org_name'];
                     $_SESSION['org_p_o_box'] = $orgDetails['p_o_box'];
                     $_SESSION['org_logo'] = $orgDetails['logo'];
                     $_SESSION['org_address'] = $orgDetails['address'];
                     $_SESSION['org_contacts'] = $orgDetails['contact_number'];
                     $_SESSION['org_email'] = $orgDetails['email']; 
                 }
 
                 // Update last login timestamp
                 $updateLoginTimeQuery = "UPDATE users SET lastlogin = NOW() WHERE id = :userid";
                 $updateLoginTimeStmt = $conn->prepare($updateLoginTimeQuery);
                 $updateLoginTimeStmt->bindParam(':userid', $current_userid);
                 $updateLoginTimeStmt->execute();
 
                 $userFound = true;
                 break;
             }
         }
 
         if (!$userFound) {
             echo json_encode(['status' => 'invalid password']);
             exit;
         }
 
         echo json_encode(["status" => "success", "userDetails" => $_SESSION]);
         exit;
     } catch (PDOException $e) {
         echo json_encode(["status" => "error", "message" => $e->getMessage()]);
         exit;
     }
 }
 
?>
