<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once 'config/dbconfig.php';

// Establish PDO connection
$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); 

// Retrieve session and input parameters
$agentname = $_SESSION["username"];
$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];

$bankname = filter_input(INPUT_POST, "bankname");
$accountname = filter_input(INPUT_POST, "accountname"); 
$accountnumber = filter_input(INPUT_POST, "accountnumber");
$bankbranch = filter_input(INPUT_POST, "bankbranch");
$swiftcode= filter_input(INPUT_POST, "swiftcode");
$sortcode = filter_input(INPUT_POST, "sortcode");
$bankstatus = filter_input(INPUT_POST, "bankstatus");  

// Corrected INSERT SQL query
$insertnewuserQuery = "INSERT INTO bank_accounts (bank_name,account_name,branch,account_number,swift_code,sort_code,account_status, org_id,sessionUserId) 
                       VALUES (:bankname, :accountname, :bankbranch, :accountnumber, :swiftcode, :sortcode, :bankstatus, :orgid,:userloggedid)";

$insertnewUser = $conn->prepare($insertnewuserQuery);

// Bind parameters to the prepared statement
$insertnewUser->bindParam(':bankname', $bankname);
$insertnewUser->bindParam(':accountname', $accountname);
$insertnewUser->bindParam(':accountnumber', $accountnumber);
$insertnewUser->bindParam(':bankbranch', $bankbranch);
$insertnewUser->bindParam(':swiftcode', $swiftcode);
$insertnewUser->bindParam(':sortcode', $sortcode);
$insertnewUser->bindParam(':bankstatus', $bankstatus); 
$insertnewUser->bindParam(':userloggedid', $userloggedid); 
$insertnewUser->bindParam(':orgid', $orgid);

// Execute the prepared statement
$insertnewUser->execute();

// Check if the insertion was successful
if ($insertnewUser->rowCount() > 0) {
    $json_data = array(
        'status' => 'Created'
    );
} else {
    $json_data = array(
        'status' => 'not created'
    );
}

// Return JSON response
echo json_encode($json_data);
exit;

?>
