<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

    session_start();
    // Insert into the database after successful upload of the database
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Fetch input data securely
    $startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
    $endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);

    // Second query to get products and transactions
    $getproductsquery = "
        SELECT 
            SUM(transaction_amount) AS totalSales,
            COUNT(id) AS transactions,
            product_name, 
            product_id, 
            product_code, 
            transaction_amount, 
            quantity, 
            bank_account_name, 
            bank_account_number 
        FROM transaction_details 
        WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active') 
        AND transaction_date BETWEEN :startDate AND :endDate 
        GROUP BY product_id 
        ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':startDate', $startDateInput);
    $getproducts->bindParam(':endDate', $endDateInput);
    $getproducts->execute();

    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    if ($getproducts->rowCount() == 0) {
        $json_data = array(
            'numofrows' => 0,
            'details' => []
        );
        echo json_encode($json_data);
        exit;
    }

    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
    }

    $json_data = array(
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'details' => $nestedData,
        'numofrows' => $totalrecords
    );

    echo json_encode($json_data);  // send data as json format
    exit;
?>
