<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

    session_start();
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Fetch input data securely
    $searchKey = filter_input(INPUT_POST, "searchKey", FILTER_DEFAULT);
    $startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
    $endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);

    // Debugging: Check if inputs are received correctly
    if (!$searchKey || !$startDateInput || !$endDateInput) {
        echo json_encode(['error' => 'Missing input data', 'searchKey' => $searchKey, 'startDate' => $startDateInput, 'endDate' => $endDateInput]);
        exit;
    }

    // Second query to get products and transactions
    $getproductsquery = "
        SELECT 
            product_id,
            product_name, 
            product_code, 
            bank_account_name, 
            bank_account_number,
            SUM(transaction_amount) AS totalSales,
            COUNT(id) AS transactions,
            SUM(quantity) AS totalQuantity 
        FROM transaction_details 
        WHERE 
            transaction_status = 'approved' 
            AND deposit_status = 'Approved' 
            AND transaction_date BETWEEN :startDate AND :endDate 
            AND depot = :searchKey 
        GROUP BY product_id, product_name, product_code, bank_account_name, bank_account_number
        ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':startDate', $startDateInput);
    $getproducts->bindParam(':endDate', $endDateInput);
    $getproducts->bindParam(':searchKey', $searchKey);

    if (!$getproducts->execute()) {
        echo json_encode(['error' => 'Error executing getproductsquery', 'details' => $getproducts->errorInfo()]);
        exit;
    }

    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    if ($getproducts->rowCount() == 0) {
        $json_data = array(
            'numofrows' => 0,
            'details' => []
        );
        echo json_encode($json_data);
        exit;
    }

    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
    }

    $json_data = array(
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'details' => $nestedData, 
        'numofrows' => $totalrecords
    );

    echo json_encode($json_data);
    exit;
?>
