<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
// Insert into the database after successful upload of the database
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Fetch input data securely
$startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
$endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);
$searchKey = filter_input(INPUT_POST, "searchKey");

$conditions = [];
$parameters = [];

if (!empty($searchKey)) {
    $conditions[] = "(cfname LIKE :search_key OR cphone LIKE :search_key OR cemail LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
}

// Add date range condition
$conditions[] = "transaction_date BETWEEN :startDate AND :endDate";
$parameters[':startDate'] = $startDateInput;
$parameters[':endDate'] = $endDateInput;

// Query to get revenue collector transaction totals
$getproductsquery = "
    SELECT
        SUM(transaction_amount) AS totalSales,
        COUNT(id) AS transactions,
        cfname,
        cemail,
        cphone,
        user_id,
        agent_name, 
        agent_id, 
        product_code, 
        transaction_amount, 
        quantity, 
        bank_account_name, 
        bank_account_number 
    FROM transaction_details
    WHERE " . implode(" AND ", $conditions) . " 
    AND (transaction_status = 'approved' OR transaction_status = 'active') 
    GROUP BY user_id
    ORDER BY cfname ASC";

$getproducts = $conn->prepare($getproductsquery);
foreach ($parameters as $key => $value) {
    $getproducts->bindValue($key, $value);
}
$getproducts->execute();

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        'numofrows' => 0,
        'details' => [], 
    );
    echo json_encode($json_data);
    exit;
}

$totalrecords = $getproducts->rowCount();
$totalQuantities = 0;
$totalAmountsCollected = 0;
$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row;
    $totalQuantities += $row['transactions'];
    $totalAmountsCollected += $row['totalSales'];
}

$json_data = array(
    'totalQuantities' => $totalQuantities,
    'totalAmountsCollected' => $totalAmountsCollected,
    'details' => $nestedData, 
    'numofrows' => $totalrecords
);

echo json_encode($json_data);  // send data as json format
exit;
?>
