<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
  //  $userloggedid = $_SESSION["userid"];

    // Retrieve and validate input 
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey"); 
    $depotname =  filter_input(INPUT_POST, "depotname");
    $depotid = filter_input(INPUT_POST, "depotid");
    
    if (empty($startDateInput)) {
        throw new Exception("startDate parameter is empty");
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();

    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }

    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare SQL query
    $conditions = [
        "transaction_date >= :start_date",
        "transaction_date <= :end_date",
        "depot = :depotname",
        "depot_id = :depotid"
    ];
    $parameters = [
        ':start_date' => $startDateFormatted,
        ':end_date' => $endDateFormatted,
        ':depotname' => $depotname,
        ':depotid' => $depotid
        
    ]; 
   
    if (!empty($searchKey)) {
        $conditions[] = "(product_name LIKE :search_key OR product_code LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    $getDriversQuery = "SELECT SUM(transaction_amount) AS product_total, product_name, product_id,product_code 
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions) . "
        GROUP BY product_id
        ORDER BY product_name ASC";

    $getDrivers = $conn->prepare($getDriversQuery);

    // Bind parameters
    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    $getDrivers->execute();

    // Process results
    $receipt_total = 0;
    $jobdetails = [];
    $totalAmountsCollected = 0;

    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalAmountsCollected += $rowDs['product_total'];
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        'totalAmountsCollected' => $totalAmountsCollected,
    ];

    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
