<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Fetch input data securely
$startDateInput = filter_input(INPUT_POST, "startDate", FILTER_DEFAULT);
$endDateInput = filter_input(INPUT_POST, "endDate", FILTER_DEFAULT);

// First query to get deposit details
$getDepositQuery = "
    SELECT bank_deposit_slip, bank_deposit_id
    FROM transaction_details 
    WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active' OR transaction_status = 'Active')  
        AND transaction_date BETWEEN :startDate AND :endDate  
    GROUP BY bank_deposit_id";

$getDeposit = $conn->prepare($getDepositQuery);
$getDeposit->bindParam(':startDate', $startDateInput);
$getDeposit->bindParam(':endDate', $endDateInput);
$getDeposit->execute();
$getDeposit->setFetchMode(PDO::FETCH_ASSOC);

$depositDetails = [];
while ($rowDeposit = $getDeposit->fetch()) {
    $depositDetails[] = array(
        'bank_deposit_slip' => $rowDeposit['bank_deposit_slip'],
        'bank_deposit_id' => $rowDeposit['bank_deposit_id']
    );
}

// Check for deposit details
if (count($depositDetails) == 0) {
    $json_data = array(
        'numofrows' => 0,
        'depositDetails' => []
    );
    echo json_encode($json_data);
    exit;
}

// Second query to get products or charts of accounts
$getproductsquery = "
    SELECT 
        SUM(transaction_amount) AS totalSales,
        COUNT(id) AS transactions,
        product_name, 
        product_id, 
        product_code, 
        transaction_amount, 
        quantity, 
        bank_account_name, 
        bank_account_number 
    FROM transaction_details 
    WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active' OR transaction_status = 'Active') 
        AND transaction_date BETWEEN :startDate AND :endDate 
    GROUP BY product_id 
    ORDER BY product_name ASC";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->bindParam(':startDate', $startDateInput);
$getproducts->bindParam(':endDate', $endDateInput);
$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        'numofrows' => 0,
        'details' => [],
        'depositDetails' => $depositDetails
    );
    echo json_encode($json_data);
    exit;
}

$totalrecords = $getproducts->rowCount();
$totalQuantities = 0;
$totalAmountsCollected = 0;
$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row;
    $totalQuantities += $row['transactions'];
    $totalAmountsCollected += $row['totalSales'];
}

// Third query to get bank balances
$getDriversQuery = "
    SELECT id, SUM(transaction_amount) AS bank_balance, transaction_date, bank_account_name, bank_account_number, deposit_slip_date 
    FROM transaction_details 
    WHERE  (transaction_status = 'approved' OR transaction_status = 'active' OR transaction_status = 'Active')       
    AND deposit_status = 'approved'
    AND transaction_date BETWEEN :startDate AND :endDate
    GROUP BY bank_account_name 
    ORDER BY bank_account_name ASC";

$getDrivers = $conn->prepare($getDriversQuery);
$getDrivers->bindParam(':startDate', $startDateInput);
$getDrivers->bindParam(':endDate', $endDateInput);
$getDrivers->execute();
$getDrivers->setFetchMode(PDO::FETCH_ASSOC);

$driverDetails = [];
if ($getDrivers->rowCount() > 0) {
    while ($rowDs = $getDrivers->fetch()) {
        $driverDetails[] = array(
            'id' => $rowDs['id'],
            'bank_balance' => $rowDs['bank_balance'],
            'bank_account_name' => $rowDs['bank_account_name'],
			'bank_account_number' => $rowDs['bank_account_number'],
            'transaction_date' => $rowDs['transaction_date'],
            'deposit_slip_date' => $rowDs['deposit_slip_date']
        );
    }
}

// New query to sum transaction_amount for 'Pending Approval' deposit_status
$getPendingApprovalSumQuery = "
    SELECT SUM(transaction_amount) AS pendingApprovalSum
    FROM transaction_details
    WHERE deposit_status = 'Pending Approval'
    AND (transaction_status = 'active' OR transaction_status = 'Active')
    AND transaction_date BETWEEN :startDate AND :endDate";

$getPendingApprovalSum = $conn->prepare($getPendingApprovalSumQuery);
$getPendingApprovalSum->bindParam(':startDate', $startDateInput);
$getPendingApprovalSum->bindParam(':endDate', $endDateInput);
$getPendingApprovalSum->execute();
$pendingApprovalSumResult = $getPendingApprovalSum->fetch(PDO::FETCH_ASSOC);
$pendingApprovalSum = $pendingApprovalSumResult['pendingApprovalSum'] ?? 0;


// New query to sum transaction_amount for 'Pending' deposit_status
$getPendingSumQuery = "
    SELECT SUM(transaction_amount) AS pendingSum
    FROM transaction_details
    WHERE deposit_status = 'Pending' 
    AND payment_mode = 'CASH'
    AND transaction_date BETWEEN :startDate AND :endDate
    AND transaction_status = 'active'";

$getPendingSum = $conn->prepare($getPendingSumQuery);
$getPendingSum->bindParam(':startDate', $startDateInput);
$getPendingSum->bindParam(':endDate', $endDateInput);
$getPendingSum->execute();
$pendingSumResult = $getPendingSum->fetch(PDO::FETCH_ASSOC);
$pendingSum = $pendingSumResult['pendingSum'] ?? 0;

// Final JSON Response
$json_data = array(
    'totalQuantities' => $totalQuantities,
    'totalAmountsCollected' => $totalAmountsCollected,
    'details' => $nestedData,
    'depositDetails' => $depositDetails,
    'driverDetails' => $driverDetails,
    'pendingApproval' => $pendingApprovalSum,
    'cash' => $pendingSum,
    'numofrows' => $totalrecords
);

echo json_encode($json_data);
exit;
?>
