<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];

    // Retrieve and validate input
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate"); 
    $agentname = filter_input(INPUT_POST, "agentName");
    $agentid = filter_input(INPUT_POST, "agentId");

    // Debugging statements
    error_log("startDateInput: " . $startDateInput);
    error_log("endDateInput: " . $endDateInput);
    error_log("agentName: " . $agentname);
    error_log("agentId: " . $agentid);
   
    if (empty($startDateInput)) {
        // Fallback to a default start date if not provided
        $startDateInput = '1970-01-01';
        error_log("startDateInput is empty, using fallback value: " . $startDateInput);
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();

    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }

    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare SQL query
    $conditions = [
        "agent_name = :agentName",
        "agent_id = :agentId"
    ];
    $parameters = [
        ':agentName' => $agentname,
        ':agentId' => $agentid
    ];

    if (!empty($startDateFormatted)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = $startDateFormatted;
    }
    if (!empty($endDateFormatted)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = $endDateFormatted;
    }

    $getDriversQuery = "
        SELECT SUM(transaction_amount) AS receipt_total, id, cfname, clname, cemail, cphone, product_name, product_id, product_code,
               transaction_amount, quantity, transaction_reference, transaction_status, agent_name, agent_id,trans_type, 
               delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, offline_receipt,
               invoiceNumber, comment, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, 
               bank_deposit_id, business_category, pacra, tpin
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions) . "
        AND deposit_status = 'Pending' 
        AND payment_mode = 'CASH'
        AND transaction_status = 'active'
        GROUP BY receipt_no
        ORDER BY receipt_no DESC";

    $getDrivers = $conn->prepare($getDriversQuery);

    // Bind parameters
    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    $getDrivers->execute();

    // Process results
    $receipt_total = 0;
    $jobdetails = [];
    $totalAmountsCollected = 0;
    $oldestTransactionDate = null;
    $newestTransactionDate = null;

    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalAmountsCollected += $rowDs['receipt_total'];

        // Determine oldest and newest transaction dates
        $transactionDate = $rowDs['transaction_date'];
        if ($oldestTransactionDate === null || $transactionDate < $oldestTransactionDate) {
            $oldestTransactionDate = $transactionDate;
        }
        if ($newestTransactionDate === null || $transactionDate > $newestTransactionDate) {
            $newestTransactionDate = $transactionDate;
        }
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        'totalAmountsCollected' => $totalAmountsCollected,
        'oldestTransactionDate' => $oldestTransactionDate,
        'newestTransactionDate' => $newestTransactionDate,
    ];

    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
